/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.groups;

import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Tag;
import io.v.v23.services.groups.Approximation;
import io.v.v23.services.groups.ApproximationType;
import io.v.v23.services.groups.GetRequest;
import io.v.v23.services.groups.GetResponse;
import io.v.v23.services.groups.GroupReaderServer;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class GroupReaderServerWrapper {
    private final GroupReaderServer server;

    public GroupReaderServerWrapper(GroupReaderServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<Set<String>>(){}.getType())));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)ApproximationType.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<Set<String>>(){}.getType())));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<Set<String>>(){}.getType())));
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<List<Approximation>>(){}.getType())));
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Resolve"), Tag.class)));
        methods.add(new Method("relate", "// Relate determines the relationships between the provided blessing// names and the members of the group.//// Given an input set of blessing names and a group defined by a set of// blessing patterns S, for each blessing name B in the input, Relate(B)// returns a set of \"remainders\" consisting of every blessing name B\"// such that there exists some B' for which B = B' B\" and B' is in S,// and \"\" if B is a member of S.//// For example, if a group is defined as S = {n1, n1:n2, n1:n2:n3}, then// Relate(n1:n2) = {n2, \"\"}.//// reqVersion specifies the expected version of the group's membership// information. If this version is set and matches the Group's current// version, the response will indicate that fact but will otherwise be// empty.//// visitedGroups is the set of groups already visited in a particular// chain of Relate calls, and is used to detect the presence of// cycles. When a cycle is detected, it is treated just like any other// error, and the result is approximated.//// Relate also returns information about all the errors encountered that// resulted in approximations, if any.//// TODO(hpucha): scrub \"Approximation\" for preserving privacy. Flesh// versioning out further. Other args we may need: option to Get() the// membership set when allowed (to avoid an extra RPC), options related// to caching this information.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)GetRequest.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)GetResponse.class))));
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("get", "// Get returns all entries in the group.// TODO(sadovsky): Flesh out this API.", inArgs, outArgs, null, null, tags));
        return new Interface("GroupReader", "io.v.v23.services.groups", "// GroupReader implements methods to read or query a group's membership// information.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("get".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"get\": %s", e.getMessage()));
            }
        }
        if ("relate".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Resolve"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"relate\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<GroupReaderServer.RelateOut> relate(VContext _ctx, StreamServerCall _call, Set<String> blessings, ApproximationType hint, String reqVersion, Set<String> visitedGroups) {
        return this.server.relate(_ctx, _call, blessings, hint, reqVersion, visitedGroups);
    }

    public ListenableFuture<GroupReaderServer.GetOut> get(VContext _ctx, StreamServerCall _call, GetRequest req, String reqVersion) {
        return this.server.get(_ctx, _call, req, reqVersion);
    }
}

