/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.groups;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.Options;
import io.v.v23.V;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.options.RpcOptions;
import io.v.v23.rpc.Client;
import io.v.v23.rpc.ClientCall;
import io.v.v23.security.access.Permissions;
import io.v.v23.services.groups.ApproximationType;
import io.v.v23.services.groups.BlessingPatternChunk;
import io.v.v23.services.groups.GetRequest;
import io.v.v23.services.groups.GroupClient;
import io.v.v23.services.groups.GroupReaderClient;
import io.v.v23.services.groups.GroupReaderClientFactory;
import io.v.v23.services.permissions.ObjectClient;
import io.v.v23.services.permissions.ObjectClientFactory;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;

final class GroupClientImpl
implements GroupClient {
    private final Client client;
    private final String vName;
    private final GroupReaderClient implGroupReader;
    private final ObjectClient implObject;

    public GroupClientImpl(Client client, String vName) {
        this.client = client;
        this.vName = vName;
        Options opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implGroupReader = GroupReaderClientFactory.getGroupReaderClient(vName, opts);
        opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implObject = ObjectClientFactory.getObjectClient(vName, opts);
    }

    private Client getClient(VContext context) {
        return this.client != null ? this.client : V.getClient(context);
    }

    @Override
    public ListenableFuture<Void> create(VContext _context, Permissions perms, List<BlessingPatternChunk> entries) {
        return this.create(_context, perms, entries, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> create(VContext _context, Permissions perms, List<BlessingPatternChunk> entries, Options _opts) {
        return this.create(_context, perms, entries, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> create(VContext _context, Permissions perms, List<BlessingPatternChunk> entries, RpcOptions _opts) {
        Object[] _args = new Object[]{perms, entries};
        Type[] _argTypes = new Type[]{new TypeToken<Permissions>(){}.getType(), new TypeToken<List<BlessingPatternChunk>>(){}.getType()};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "create", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> delete(VContext _context, String version) {
        return this.delete(_context, version, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> delete(VContext _context, String version, Options _opts) {
        return this.delete(_context, version, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> delete(VContext _context, String version, RpcOptions _opts) {
        Object[] _args = new Object[]{version};
        Type[] _argTypes = new Type[]{String.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "delete", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> add(VContext _context, BlessingPatternChunk entry, String version) {
        return this.add(_context, entry, version, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> add(VContext _context, BlessingPatternChunk entry, String version, Options _opts) {
        return this.add(_context, entry, version, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> add(VContext _context, BlessingPatternChunk entry, String version, RpcOptions _opts) {
        Object[] _args = new Object[]{entry, version};
        Type[] _argTypes = new Type[]{BlessingPatternChunk.class, String.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "add", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> remove(VContext _context, BlessingPatternChunk entry, String version) {
        return this.remove(_context, entry, version, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> remove(VContext _context, BlessingPatternChunk entry, String version, Options _opts) {
        return this.remove(_context, entry, version, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> remove(VContext _context, BlessingPatternChunk entry, String version, RpcOptions _opts) {
        Object[] _args = new Object[]{entry, version};
        Type[] _argTypes = new Type[]{BlessingPatternChunk.class, String.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "remove", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<GroupReaderClient.GetOut> get(VContext _context, GetRequest req, String reqVersion) {
        return this.implGroupReader.get(_context, req, reqVersion);
    }

    @Override
    @Deprecated
    public ListenableFuture<GroupReaderClient.GetOut> get(VContext _context, GetRequest req, String reqVersion, Options _opts) {
        return this.implGroupReader.get(_context, req, reqVersion, _opts);
    }

    @Override
    public ListenableFuture<GroupReaderClient.GetOut> get(VContext _context, GetRequest req, String reqVersion, RpcOptions _opts) {
        return this.implGroupReader.get(_context, req, reqVersion, _opts);
    }

    @Override
    public ListenableFuture<GroupReaderClient.RelateOut> relate(VContext _context, Set<String> blessings, ApproximationType hint, String reqVersion, Set<String> visitedGroups) {
        return this.implGroupReader.relate(_context, blessings, hint, reqVersion, visitedGroups);
    }

    @Override
    @Deprecated
    public ListenableFuture<GroupReaderClient.RelateOut> relate(VContext _context, Set<String> blessings, ApproximationType hint, String reqVersion, Set<String> visitedGroups, Options _opts) {
        return this.implGroupReader.relate(_context, blessings, hint, reqVersion, visitedGroups, _opts);
    }

    @Override
    public ListenableFuture<GroupReaderClient.RelateOut> relate(VContext _context, Set<String> blessings, ApproximationType hint, String reqVersion, Set<String> visitedGroups, RpcOptions _opts) {
        return this.implGroupReader.relate(_context, blessings, hint, reqVersion, visitedGroups, _opts);
    }

    @Override
    public ListenableFuture<ObjectClient.GetPermissionsOut> getPermissions(VContext _context) {
        return this.implObject.getPermissions(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<ObjectClient.GetPermissionsOut> getPermissions(VContext _context, Options _opts) {
        return this.implObject.getPermissions(_context, _opts);
    }

    @Override
    public ListenableFuture<ObjectClient.GetPermissionsOut> getPermissions(VContext _context, RpcOptions _opts) {
        return this.implObject.getPermissions(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> setPermissions(VContext _context, Permissions perms, String version) {
        return this.implObject.setPermissions(_context, perms, version);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> setPermissions(VContext _context, Permissions perms, String version, Options _opts) {
        return this.implObject.setPermissions(_context, perms, version, _opts);
    }

    @Override
    public ListenableFuture<Void> setPermissions(VContext _context, Permissions perms, String version, RpcOptions _opts) {
        return this.implObject.setPermissions(_context, perms, version, _opts);
    }
}

