/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.device;

import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Permissions;
import io.v.v23.security.access.Tag;
import io.v.v23.services.application.Packages;
import io.v.v23.services.device.ApplicationServerWrapper;
import io.v.v23.services.device.Association;
import io.v.v23.services.device.Config;
import io.v.v23.services.device.Description;
import io.v.v23.services.device.DeviceServer;
import io.v.v23.services.device.Status;
import io.v.v23.services.permissions.ObjectServer;
import io.v.v23.services.permissions.ObjectServerWrapper;
import io.v.v23.services.tidyable.TidyableServerWrapper;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.Duration;

public final class DeviceServerWrapper {
    private final DeviceServer server;
    private final ObjectServerWrapper wrapperObject;
    private final ApplicationServerWrapper wrapperApplication;
    private final TidyableServerWrapper wrapperTidyable;

    public DeviceServerWrapper(DeviceServer server) {
        this.server = server;
        this.wrapperObject = new ObjectServerWrapper(server);
        this.wrapperApplication = new ApplicationServerWrapper(server);
        this.wrapperTidyable = new TidyableServerWrapper(server);
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Description.class))));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("describe", "// Describe generates a description of the device.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)io.v.v23.services.binary.Description.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Boolean.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("isRunnable", "// IsRunnable checks if the device can execute the given binary.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Duration.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("reset", "// Reset resets the device. If the deadline is non-zero and the device// in question is still running after the given deadline expired,// reset of the device is enforced.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<List<String>>(){}.getType())));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("associateAccount", "// AssociateAccount associates a local  system account name with the provided// Vanadium identities. It replaces the existing association if one already exists for that// identity. Setting an AccountName to \"\" removes the association for each// listed identity.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<List<Association>>(){}.getType())));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("listAssociations", "// ListAssociations returns all of the associations between Vanadium identities// and system names.", inArgs, outArgs, null, null, tags));
        return new Interface("Device", "io.v.v23.services.device", "// Device can be used to manage a device remotely using an object name that// identifies it.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("associateAccount".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"associateAccount\": %s", e.getMessage()));
            }
        }
        if ("describe".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"describe\": %s", e.getMessage()));
            }
        }
        if ("isRunnable".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"isRunnable\": %s", e.getMessage()));
            }
        }
        if ("listAssociations".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"listAssociations\": %s", e.getMessage()));
            }
        }
        if ("reset".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"reset\": %s", e.getMessage()));
            }
        }
        VdlValue[] tags = this.wrapperObject.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        tags = this.wrapperApplication.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        tags = this.wrapperTidyable.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        return null;
    }

    public ListenableFuture<Description> describe(VContext _ctx, StreamServerCall _call) {
        return this.server.describe(_ctx, _call);
    }

    public ListenableFuture<Boolean> isRunnable(VContext _ctx, StreamServerCall _call, io.v.v23.services.binary.Description description) {
        return this.server.isRunnable(_ctx, _call, description);
    }

    public ListenableFuture<Void> reset(VContext _ctx, StreamServerCall _call, Duration deadline) {
        return this.server.reset(_ctx, _call, deadline);
    }

    public ListenableFuture<Void> associateAccount(VContext _ctx, StreamServerCall _call, List<String> identityNames, String accountName) {
        return this.server.associateAccount(_ctx, _call, identityNames, accountName);
    }

    public ListenableFuture<List<Association>> listAssociations(VContext _ctx, StreamServerCall _call) {
        return this.server.listAssociations(_ctx, _call);
    }

    public ListenableFuture<String> debug(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperApplication.debug(ctx, call);
    }

    public ListenableFuture<Void> delete(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperApplication.delete(ctx, call);
    }

    public ListenableFuture<String> install(VContext ctx, StreamServerCall call, String name, Config config, Packages packages) throws VException {
        return this.wrapperApplication.install(ctx, call, name, config, packages);
    }

    public ListenableFuture<String> instantiate(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperApplication.instantiate(ctx, call);
    }

    public ListenableFuture<Void> kill(VContext ctx, StreamServerCall call, Duration deadline) throws VException {
        return this.wrapperApplication.kill(ctx, call, deadline);
    }

    public ListenableFuture<Void> revert(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperApplication.revert(ctx, call);
    }

    public ListenableFuture<Void> run(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperApplication.run(ctx, call);
    }

    public ListenableFuture<Status> status(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperApplication.status(ctx, call);
    }

    public ListenableFuture<Void> uninstall(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperApplication.uninstall(ctx, call);
    }

    public ListenableFuture<Void> update(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperApplication.update(ctx, call);
    }

    public ListenableFuture<Void> updateTo(VContext ctx, StreamServerCall call, String name) throws VException {
        return this.wrapperApplication.updateTo(ctx, call, name);
    }

    public ListenableFuture<ObjectServer.GetPermissionsOut> getPermissions(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperObject.getPermissions(ctx, call);
    }

    public ListenableFuture<Void> setPermissions(VContext ctx, StreamServerCall call, Permissions perms, String version) throws VException {
        return this.wrapperObject.setPermissions(ctx, call, perms, version);
    }

    public ListenableFuture<Void> tidyNow(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperTidyable.tidyNow(ctx, call);
    }
}

