/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.device;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.Options;
import io.v.v23.V;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.options.RpcOptions;
import io.v.v23.rpc.Client;
import io.v.v23.rpc.ClientCall;
import io.v.v23.security.access.Permissions;
import io.v.v23.services.application.Packages;
import io.v.v23.services.device.ApplicationClient;
import io.v.v23.services.device.ApplicationClientFactory;
import io.v.v23.services.device.Association;
import io.v.v23.services.device.BlessClientMessage;
import io.v.v23.services.device.BlessServerMessage;
import io.v.v23.services.device.Config;
import io.v.v23.services.device.Description;
import io.v.v23.services.device.DeviceClient;
import io.v.v23.services.device.Status;
import io.v.v23.services.permissions.ObjectClient;
import io.v.v23.services.permissions.ObjectClientFactory;
import io.v.v23.services.tidyable.TidyableClient;
import io.v.v23.services.tidyable.TidyableClientFactory;
import io.v.v23.vdl.ClientStream;
import java.lang.reflect.Type;
import java.util.List;
import org.joda.time.Duration;

final class DeviceClientImpl
implements DeviceClient {
    private final Client client;
    private final String vName;
    private final ObjectClient implObject;
    private final ApplicationClient implApplication;
    private final TidyableClient implTidyable;

    public DeviceClientImpl(Client client, String vName) {
        this.client = client;
        this.vName = vName;
        Options opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implObject = ObjectClientFactory.getObjectClient(vName, opts);
        opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implApplication = ApplicationClientFactory.getApplicationClient(vName, opts);
        opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implTidyable = TidyableClientFactory.getTidyableClient(vName, opts);
    }

    private Client getClient(VContext context) {
        return this.client != null ? this.client : V.getClient(context);
    }

    @Override
    public ListenableFuture<Description> describe(VContext _context) {
        return this.describe(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Description> describe(VContext _context, Options _opts) {
        return this.describe(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Description> describe(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "describe", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Description>(){

            public ListenableFuture<Description> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{Description.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Description>(){

                    public Description apply(Object[] _results) {
                        return (Description)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Boolean> isRunnable(VContext _context, io.v.v23.services.binary.Description description) {
        return this.isRunnable(_context, description, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Boolean> isRunnable(VContext _context, io.v.v23.services.binary.Description description, Options _opts) {
        return this.isRunnable(_context, description, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Boolean> isRunnable(VContext _context, io.v.v23.services.binary.Description description, RpcOptions _opts) {
        Object[] _args = new Object[]{description};
        Type[] _argTypes = new Type[]{io.v.v23.services.binary.Description.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "isRunnable", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Boolean>(){

            public ListenableFuture<Boolean> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{Boolean.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Boolean>(){

                    public Boolean apply(Object[] _results) {
                        return (Boolean)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> reset(VContext _context, Duration deadline) {
        return this.reset(_context, deadline, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> reset(VContext _context, Duration deadline, Options _opts) {
        return this.reset(_context, deadline, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> reset(VContext _context, Duration deadline, RpcOptions _opts) {
        Object[] _args = new Object[]{deadline};
        Type[] _argTypes = new Type[]{Duration.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "reset", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> associateAccount(VContext _context, List<String> identityNames, String accountName) {
        return this.associateAccount(_context, identityNames, accountName, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> associateAccount(VContext _context, List<String> identityNames, String accountName, Options _opts) {
        return this.associateAccount(_context, identityNames, accountName, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> associateAccount(VContext _context, List<String> identityNames, String accountName, RpcOptions _opts) {
        Object[] _args = new Object[]{identityNames, accountName};
        Type[] _argTypes = new Type[]{new TypeToken<List<String>>(){}.getType(), String.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "associateAccount", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<List<Association>> listAssociations(VContext _context) {
        return this.listAssociations(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<List<Association>> listAssociations(VContext _context, Options _opts) {
        return this.listAssociations(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<List<Association>> listAssociations(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "listAssociations", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, List<Association>>(){

            public ListenableFuture<List<Association>> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{new TypeToken<List<Association>>(){}.getType()};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], List<Association>>(){

                    public List<Association> apply(Object[] _results) {
                        return (List)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<String> debug(VContext _context) {
        return this.implApplication.debug(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<String> debug(VContext _context, Options _opts) {
        return this.implApplication.debug(_context, _opts);
    }

    @Override
    public ListenableFuture<String> debug(VContext _context, RpcOptions _opts) {
        return this.implApplication.debug(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> delete(VContext _context) {
        return this.implApplication.delete(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> delete(VContext _context, Options _opts) {
        return this.implApplication.delete(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> delete(VContext _context, RpcOptions _opts) {
        return this.implApplication.delete(_context, _opts);
    }

    @Override
    public ListenableFuture<String> install(VContext _context, String name, Config config, Packages packages) {
        return this.implApplication.install(_context, name, config, packages);
    }

    @Override
    @Deprecated
    public ListenableFuture<String> install(VContext _context, String name, Config config, Packages packages, Options _opts) {
        return this.implApplication.install(_context, name, config, packages, _opts);
    }

    @Override
    public ListenableFuture<String> install(VContext _context, String name, Config config, Packages packages, RpcOptions _opts) {
        return this.implApplication.install(_context, name, config, packages, _opts);
    }

    @Override
    public ClientStream<BlessClientMessage, BlessServerMessage, String> instantiate(VContext _context) {
        return this.implApplication.instantiate(_context);
    }

    @Override
    @Deprecated
    public ClientStream<BlessClientMessage, BlessServerMessage, String> instantiate(VContext _context, Options _opts) {
        return this.implApplication.instantiate(_context, _opts);
    }

    @Override
    public ClientStream<BlessClientMessage, BlessServerMessage, String> instantiate(VContext _context, RpcOptions _opts) {
        return this.implApplication.instantiate(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> kill(VContext _context, Duration deadline) {
        return this.implApplication.kill(_context, deadline);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> kill(VContext _context, Duration deadline, Options _opts) {
        return this.implApplication.kill(_context, deadline, _opts);
    }

    @Override
    public ListenableFuture<Void> kill(VContext _context, Duration deadline, RpcOptions _opts) {
        return this.implApplication.kill(_context, deadline, _opts);
    }

    @Override
    public ListenableFuture<Void> revert(VContext _context) {
        return this.implApplication.revert(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> revert(VContext _context, Options _opts) {
        return this.implApplication.revert(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> revert(VContext _context, RpcOptions _opts) {
        return this.implApplication.revert(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> run(VContext _context) {
        return this.implApplication.run(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> run(VContext _context, Options _opts) {
        return this.implApplication.run(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> run(VContext _context, RpcOptions _opts) {
        return this.implApplication.run(_context, _opts);
    }

    @Override
    public ListenableFuture<Status> status(VContext _context) {
        return this.implApplication.status(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<Status> status(VContext _context, Options _opts) {
        return this.implApplication.status(_context, _opts);
    }

    @Override
    public ListenableFuture<Status> status(VContext _context, RpcOptions _opts) {
        return this.implApplication.status(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> uninstall(VContext _context) {
        return this.implApplication.uninstall(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> uninstall(VContext _context, Options _opts) {
        return this.implApplication.uninstall(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> uninstall(VContext _context, RpcOptions _opts) {
        return this.implApplication.uninstall(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> update(VContext _context) {
        return this.implApplication.update(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> update(VContext _context, Options _opts) {
        return this.implApplication.update(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> update(VContext _context, RpcOptions _opts) {
        return this.implApplication.update(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> updateTo(VContext _context, String name) {
        return this.implApplication.updateTo(_context, name);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> updateTo(VContext _context, String name, Options _opts) {
        return this.implApplication.updateTo(_context, name, _opts);
    }

    @Override
    public ListenableFuture<Void> updateTo(VContext _context, String name, RpcOptions _opts) {
        return this.implApplication.updateTo(_context, name, _opts);
    }

    @Override
    public ListenableFuture<ObjectClient.GetPermissionsOut> getPermissions(VContext _context) {
        return this.implObject.getPermissions(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<ObjectClient.GetPermissionsOut> getPermissions(VContext _context, Options _opts) {
        return this.implObject.getPermissions(_context, _opts);
    }

    @Override
    public ListenableFuture<ObjectClient.GetPermissionsOut> getPermissions(VContext _context, RpcOptions _opts) {
        return this.implObject.getPermissions(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> setPermissions(VContext _context, Permissions perms, String version) {
        return this.implObject.setPermissions(_context, perms, version);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> setPermissions(VContext _context, Permissions perms, String version, Options _opts) {
        return this.implObject.setPermissions(_context, perms, version, _opts);
    }

    @Override
    public ListenableFuture<Void> setPermissions(VContext _context, Permissions perms, String version, RpcOptions _opts) {
        return this.implObject.setPermissions(_context, perms, version, _opts);
    }

    @Override
    public ListenableFuture<Void> tidyNow(VContext _context) {
        return this.implTidyable.tidyNow(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> tidyNow(VContext _context, Options _opts) {
        return this.implTidyable.tidyNow(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> tidyNow(VContext _context, RpcOptions _opts) {
        return this.implTidyable.tidyNow(_context, _opts);
    }
}

