/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.device;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Permissions;
import io.v.v23.security.access.Tag;
import io.v.v23.services.application.Packages;
import io.v.v23.services.device.ApplicationServer;
import io.v.v23.services.device.BlessClientMessage;
import io.v.v23.services.device.BlessServerMessage;
import io.v.v23.services.device.Config;
import io.v.v23.services.device.Status;
import io.v.v23.services.permissions.ObjectServer;
import io.v.v23.services.permissions.ObjectServerWrapper;
import io.v.v23.vdl.ServerStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.joda.time.Duration;

public final class ApplicationServerWrapper {
    private final ApplicationServer server;
    private final ObjectServerWrapper wrapperObject;

    public ApplicationServerWrapper(ApplicationServer server) {
        this.server = server;
        this.wrapperObject = new ObjectServerWrapper(server);
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<Config>(){}.getType())));
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<Packages>(){}.getType())));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("install", "// Install installs the application identified by the first argument and// returns an object name suffix that identifies the new installation.//// The name argument should be an object name for an application// envelope.  The service it identifies must implement// repository.Application, and is expected to return either the// requested version (if the object name encodes a specific version), or// otherwise the latest available version, as appropriate.  This object// name will be used by default by the Update method, as a source for// updated application envelopes (can be overriden by setting// AppOriginConfigKey in the config).//// The config argument specifies config settings that will take// precedence over those present in the application envelope.//// The packages argument specifies packages to be installed in addition// to those specified in the envelope.  If a package in the envelope has// the same key, the package in the packages argument takes precedence.//// The returned suffix, when appended to the name used to reach the// receiver for Install, can be used to control the installation object.// The suffix will contain the title of the application as a prefix,// which can then be used to control all the installations of the given// application.// TODO(rjkroege): Use customized labels.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("uninstall", "// Uninstall uninstalls an application installation.// The installation must be in state Active.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("instantiate", "// Instantiate creates an instance of an application installation.// The installation must be in state Active.//// The server sends the application instance's Public Key on the stream.// When the client receives the Public Key it must send Blessings back// to the server. When the instance is created, the server returns the// instance name to the client.//// Client                       Server//  \"object\".Instantiate() -->//                         <--  InstancePublicKey//  AppBlessings           -->//                         <--  return InstanceName", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("delete", "// Delete deletes an instance.  Once deleted, the instance cannot be// revived.// The instance must be in state NotRunning.//// If called against a Device, causes the Device to shut itself down.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("run", "// Run begins execution of an application instance.// The instance must be in state NotRunning.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Duration.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("kill", "// Kill attempts a clean shutdown an of application instance.// The instance must be in state Running.//// If the deadline is non-zero and the instance in question is still// running after the given deadline, shutdown of the instance is// enforced.//// If called against a Device, causes the Device to stop itself (which// may or may not result in a restart depending on the device manager// setup).", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("update", "// Update updates an application installation's version to a new version// created from the envelope at the object name provided during Install.// If the new application envelope contains a different application// title, the update does not occur, and an error is returned.  The// installation must be in state Active.//// Update updates an application instance's version to the current// installation version.  The instance must be in state NotRunning.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("updateTo", "// UpdateTo updates the application installation(s) to the application// specified by the object name argument.  If the new application// envelope contains a different application title, the update does not// occur, and an error is returned.// The installation must be in state Active.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("revert", "// Revert reverts an application installation's version to the previous// version of its current version.  The installation must be in state// Active.//// Revert reverts an application instance's version to the previous// version of its current version.  The instance must be in state// NotRunning.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Debug"), Tag.class)));
        methods.add(new Method("debug", "// Debug returns debug information about the application installation or// instance.  This is generally highly implementation-specific, and// presented in an unstructured form.  No guarantees are given about the// stability of the format, and parsing it programmatically is// specifically discouraged.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Status.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("status", "// Status returns structured information about the application// installation or instance.", inArgs, outArgs, null, null, tags));
        return new Interface("Application", "io.v.v23.services.device", "// Application can be used to manage applications on a device. This interface// will be invoked using an object name that identifies the application and its// installations and instances where applicable.//// An application is defined by a title.  An application can have multiple// installations on a device.  The installations are grouped under the same// application, but are otherwise independent of each other.  Each installation// can have zero or more instances (which can be running or not).  The instances// are independent of each other, and do not share state (like local storage).// Interaction among instances should occur via Vanadium RPC, facilitated by the// local mounttable.//// The device manager supports versioning of applications.  Each installation// maintains a tree of versions, where a version is defined by a specific// envelope.  The tree structure comes from 'previous version' references: each// version (except the initial installation version) maintains a reference to// the version that preceded it.  The installation maintains a current version// reference that is used for new instances.  Each update operation on the// installation creates a new version, sets the previous reference of the new// version to the current version, and then updates the current version to refer// to the new version.  Each revert operation on the installation sets the// current version to the previous version of the current version.  Each// instance maintains a current version reference that is used to run the// instance.  The initial version of the instance is set to the current version// of the installation at the time of instantiation.  Each update operation on// the instance updates the instance's current version to the current version of// the installation.  Each revert operation on the instance updates the// instance's current version to the previous version of the instance's version.//// The Application interface methods can be divided based on their intended// receiver://// 1) Method receiver is an application://     - Install()//// 2) Method receiver is an application installation://     - Instantiate()//     - Uninstall()//// 3) Method receiver is an application instance://     - Run()//     - Kill()//     - Delete()//// 4) Method receiver is an application installation or instance://     - Update()//     - Revert()//// The following methods complement one another://     - Install() and Uninstall()//     - Instantiate() and Delete()//     - Run() and Kill()//     - Update() and Revert()//////// Examples://// Install Google Maps on the device.//     device/apps.Install(\"/google.com/appstore/maps\", nil, nil) --> \"google maps/0\"//// Create and start an instance of the previously installed maps application// installation.//    device/apps/google maps/0.Instantiate() --> { \"0\" }//    device/apps/google maps/0/0.Run()//// Create and start a second instance of the previously installed maps// application installation.//    device/apps/google maps/0.Instantiate() --> { \"1\" }//    device/apps/google maps/0/1.Run()//// Kill and delete the first instance previously started.//    device/apps/google maps/0/0.Kill()//    device/apps/google maps/0/0.Delete()//// Install a second Google Maps installation.//    device/apps.Install(\"/google.com/appstore/maps\", nil, nil) --> \"google maps/1\"//// Update the second maps installation to the latest version available.//    device/apps/google maps/1.Update()//// Update the first maps installation to a specific version.//    device/apps/google maps/0.UpdateTo(\"/google.com/appstore/beta/maps\")//// Finally, an application installation instance can be in one of three abstract// states: 1) \"does not exist/deleted\", 2) \"running\", or 3) \"not-running\". The// interface methods transition between these abstract states using the// following state machine:////    apply(Instantiate(), \"does not exist\") = \"not-running\"//    apply(Run(), \"not-running\") = \"running\"//    apply(Kill(), \"running\") = \"not-running\"//    apply(Delete(), \"not-running\") = \"deleted\"", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("debug".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Debug"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"debug\": %s", e.getMessage()));
            }
        }
        if ("delete".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"delete\": %s", e.getMessage()));
            }
        }
        if ("install".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"install\": %s", e.getMessage()));
            }
        }
        if ("instantiate".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"instantiate\": %s", e.getMessage()));
            }
        }
        if ("kill".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"kill\": %s", e.getMessage()));
            }
        }
        if ("revert".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"revert\": %s", e.getMessage()));
            }
        }
        if ("run".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"run\": %s", e.getMessage()));
            }
        }
        if ("status".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"status\": %s", e.getMessage()));
            }
        }
        if ("uninstall".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"uninstall\": %s", e.getMessage()));
            }
        }
        if ("update".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"update\": %s", e.getMessage()));
            }
        }
        if ("updateTo".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"updateTo\": %s", e.getMessage()));
            }
        }
        VdlValue[] tags = this.wrapperObject.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        return null;
    }

    public ListenableFuture<String> install(VContext _ctx, StreamServerCall _call, String name, Config config, Packages packages) {
        return this.server.install(_ctx, _call, name, config, packages);
    }

    public ListenableFuture<Void> uninstall(VContext _ctx, StreamServerCall _call) {
        return this.server.uninstall(_ctx, _call);
    }

    public ListenableFuture<String> instantiate(VContext _ctx, final StreamServerCall _call) {
        ServerStream<BlessServerMessage, BlessClientMessage> _stream = new ServerStream<BlessServerMessage, BlessClientMessage>(){

            @Override
            public ListenableFuture<Void> send(BlessServerMessage _item) {
                Class<BlessServerMessage> _type = BlessServerMessage.class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<BlessClientMessage> recv() {
                Class<BlessClientMessage> _type = BlessClientMessage.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, BlessClientMessage>(){

                    public BlessClientMessage apply(Object result) {
                        return (BlessClientMessage)result;
                    }
                });
            }
        };
        return this.server.instantiate(_ctx, _call, _stream);
    }

    public ListenableFuture<Void> delete(VContext _ctx, StreamServerCall _call) {
        return this.server.delete(_ctx, _call);
    }

    public ListenableFuture<Void> run(VContext _ctx, StreamServerCall _call) {
        return this.server.run(_ctx, _call);
    }

    public ListenableFuture<Void> kill(VContext _ctx, StreamServerCall _call, Duration deadline) {
        return this.server.kill(_ctx, _call, deadline);
    }

    public ListenableFuture<Void> update(VContext _ctx, StreamServerCall _call) {
        return this.server.update(_ctx, _call);
    }

    public ListenableFuture<Void> updateTo(VContext _ctx, StreamServerCall _call, String name) {
        return this.server.updateTo(_ctx, _call, name);
    }

    public ListenableFuture<Void> revert(VContext _ctx, StreamServerCall _call) {
        return this.server.revert(_ctx, _call);
    }

    public ListenableFuture<String> debug(VContext _ctx, StreamServerCall _call) {
        return this.server.debug(_ctx, _call);
    }

    public ListenableFuture<Status> status(VContext _ctx, StreamServerCall _call) {
        return this.server.status(_ctx, _call);
    }

    public ListenableFuture<ObjectServer.GetPermissionsOut> getPermissions(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperObject.getPermissions(ctx, call);
    }

    public ListenableFuture<Void> setPermissions(VContext ctx, StreamServerCall call, Permissions perms, String version) throws VException {
        return this.wrapperObject.setPermissions(ctx, call, perms, version);
    }
}

