/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.device;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.Options;
import io.v.v23.V;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.options.RpcOptions;
import io.v.v23.rpc.Client;
import io.v.v23.rpc.ClientCall;
import io.v.v23.security.access.Permissions;
import io.v.v23.services.application.Packages;
import io.v.v23.services.device.ApplicationClient;
import io.v.v23.services.device.BlessClientMessage;
import io.v.v23.services.device.BlessServerMessage;
import io.v.v23.services.device.Config;
import io.v.v23.services.device.Status;
import io.v.v23.services.permissions.ObjectClient;
import io.v.v23.services.permissions.ObjectClientFactory;
import io.v.v23.vdl.ClientStream;
import java.lang.reflect.Type;
import org.joda.time.Duration;

final class ApplicationClientImpl
implements ApplicationClient {
    private final Client client;
    private final String vName;
    private final ObjectClient implObject;

    public ApplicationClientImpl(Client client, String vName) {
        this.client = client;
        this.vName = vName;
        Options opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implObject = ObjectClientFactory.getObjectClient(vName, opts);
    }

    private Client getClient(VContext context) {
        return this.client != null ? this.client : V.getClient(context);
    }

    @Override
    public ListenableFuture<String> install(VContext _context, String name, Config config, Packages packages) {
        return this.install(_context, name, config, packages, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<String> install(VContext _context, String name, Config config, Packages packages, Options _opts) {
        return this.install(_context, name, config, packages, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<String> install(VContext _context, String name, Config config, Packages packages, RpcOptions _opts) {
        Object[] _args = new Object[]{name, config, packages};
        Type[] _argTypes = new Type[]{String.class, new TypeToken<Config>(){}.getType(), new TypeToken<Packages>(){}.getType()};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "install", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, String>(){

            public ListenableFuture<String> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{String.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], String>(){

                    public String apply(Object[] _results) {
                        return (String)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> uninstall(VContext _context) {
        return this.uninstall(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> uninstall(VContext _context, Options _opts) {
        return this.uninstall(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> uninstall(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "uninstall", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ClientStream<BlessClientMessage, BlessServerMessage, String> instantiate(VContext _context) {
        return this.instantiate(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ClientStream<BlessClientMessage, BlessServerMessage, String> instantiate(VContext _context, Options _opts) {
        return this.instantiate(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ClientStream<BlessClientMessage, BlessServerMessage, String> instantiate(final VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        final ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "instantiate", _args, _argTypes, _opts);
        return new ClientStream<BlessClientMessage, BlessServerMessage, String>(){

            @Override
            public ListenableFuture<Void> send(final BlessClientMessage item) {
                final Class<BlessClientMessage> type = BlessClientMessage.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.send(item, type);
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> close() {
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.closeSend();
                    }
                }));
            }

            @Override
            public ListenableFuture<BlessServerMessage> recv() {
                final Class<BlessServerMessage> recvType = BlessServerMessage.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, BlessServerMessage>(){

                    public ListenableFuture<BlessServerMessage> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.recv(recvType), (Function)new Function<Object, BlessServerMessage>(){

                            public BlessServerMessage apply(Object result) {
                                return (BlessServerMessage)result;
                            }
                        });
                    }
                }));
            }

            @Override
            public ListenableFuture<String> finish() {
                final Type[] resultTypes = new Type[]{String.class};
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, String>(){

                    public ListenableFuture<String> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.finish(resultTypes), (Function)new Function<Object[], String>(){

                            public String apply(Object[] _results) {
                                return (String)_results[0];
                            }
                        });
                    }
                }));
            }
        };
    }

    @Override
    public ListenableFuture<Void> delete(VContext _context) {
        return this.delete(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> delete(VContext _context, Options _opts) {
        return this.delete(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> delete(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "delete", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> run(VContext _context) {
        return this.run(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> run(VContext _context, Options _opts) {
        return this.run(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> run(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "run", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> kill(VContext _context, Duration deadline) {
        return this.kill(_context, deadline, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> kill(VContext _context, Duration deadline, Options _opts) {
        return this.kill(_context, deadline, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> kill(VContext _context, Duration deadline, RpcOptions _opts) {
        Object[] _args = new Object[]{deadline};
        Type[] _argTypes = new Type[]{Duration.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "kill", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> update(VContext _context) {
        return this.update(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> update(VContext _context, Options _opts) {
        return this.update(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> update(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "update", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> updateTo(VContext _context, String name) {
        return this.updateTo(_context, name, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> updateTo(VContext _context, String name, Options _opts) {
        return this.updateTo(_context, name, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> updateTo(VContext _context, String name, RpcOptions _opts) {
        Object[] _args = new Object[]{name};
        Type[] _argTypes = new Type[]{String.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "updateTo", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> revert(VContext _context) {
        return this.revert(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> revert(VContext _context, Options _opts) {
        return this.revert(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> revert(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "revert", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<String> debug(VContext _context) {
        return this.debug(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<String> debug(VContext _context, Options _opts) {
        return this.debug(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<String> debug(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "debug", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, String>(){

            public ListenableFuture<String> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{String.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], String>(){

                    public String apply(Object[] _results) {
                        return (String)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Status> status(VContext _context) {
        return this.status(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Status> status(VContext _context, Options _opts) {
        return this.status(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Status> status(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "status", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Status>(){

            public ListenableFuture<Status> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{Status.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Status>(){

                    public Status apply(Object[] _results) {
                        return (Status)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<ObjectClient.GetPermissionsOut> getPermissions(VContext _context) {
        return this.implObject.getPermissions(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<ObjectClient.GetPermissionsOut> getPermissions(VContext _context, Options _opts) {
        return this.implObject.getPermissions(_context, _opts);
    }

    @Override
    public ListenableFuture<ObjectClient.GetPermissionsOut> getPermissions(VContext _context, RpcOptions _opts) {
        return this.implObject.getPermissions(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> setPermissions(VContext _context, Permissions perms, String version) {
        return this.implObject.setPermissions(_context, perms, version);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> setPermissions(VContext _context, Permissions perms, String version, Options _opts) {
        return this.implObject.setPermissions(_context, perms, version, _opts);
    }

    @Override
    public ListenableFuture<Void> setPermissions(VContext _context, Permissions perms, String version, RpcOptions _opts) {
        return this.implObject.setPermissions(_context, perms, version, _opts);
    }
}

