/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.build;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.services.binary.Description;
import io.v.v23.services.build.Architecture;
import io.v.v23.services.build.BuilderServer;
import io.v.v23.services.build.File;
import io.v.v23.services.build.OperatingSystem;
import io.v.v23.vdl.ServerStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class BuilderServerWrapper {
    private final BuilderServer server;

    public BuilderServerWrapper(BuilderServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Architecture.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)OperatingSystem.class))));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)byte[].class))));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        methods.add(new Method("build", "// Build streams sources to the build server, which then attempts to// build the sources and streams back the compiled binaries.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Description.class))));
        tags = new ArrayList();
        methods.add(new Method("describe", "// Describe generates a description for a binary identified by// the given Object name.", inArgs, outArgs, null, null, tags));
        return new Interface("Builder", "io.v.v23.services.build", "// Builder describes an interface for building binaries from source.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("build".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"build\": %s", e.getMessage()));
            }
        }
        if ("describe".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"describe\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<byte[]> build(VContext _ctx, final StreamServerCall _call, Architecture arch, OperatingSystem os) {
        ServerStream<File, File> _stream = new ServerStream<File, File>(){

            @Override
            public ListenableFuture<Void> send(File _item) {
                Class<File> _type = File.class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<File> recv() {
                Class<File> _type = File.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, File>(){

                    public File apply(Object result) {
                        return (File)result;
                    }
                });
            }
        };
        return this.server.build(_ctx, _call, arch, os, _stream);
    }

    public ListenableFuture<Description> describe(VContext _ctx, StreamServerCall _call, String name) {
        return this.server.describe(_ctx, _call, name);
    }
}

