/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.build;

import com.google.common.base.Function;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.Options;
import io.v.v23.V;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.options.RpcOptions;
import io.v.v23.rpc.Client;
import io.v.v23.rpc.ClientCall;
import io.v.v23.services.binary.Description;
import io.v.v23.services.build.Architecture;
import io.v.v23.services.build.BuilderClient;
import io.v.v23.services.build.File;
import io.v.v23.services.build.OperatingSystem;
import io.v.v23.vdl.ClientStream;
import java.lang.reflect.Type;

final class BuilderClientImpl
implements BuilderClient {
    private final Client client;
    private final String vName;

    public BuilderClientImpl(Client client, String vName) {
        this.client = client;
        this.vName = vName;
    }

    private Client getClient(VContext context) {
        return this.client != null ? this.client : V.getClient(context);
    }

    @Override
    public ClientStream<File, File, byte[]> build(VContext _context, Architecture arch, OperatingSystem os) {
        return this.build(_context, arch, os, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ClientStream<File, File, byte[]> build(VContext _context, Architecture arch, OperatingSystem os, Options _opts) {
        return this.build(_context, arch, os, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ClientStream<File, File, byte[]> build(final VContext _context, Architecture arch, OperatingSystem os, RpcOptions _opts) {
        Object[] _args = new Object[]{arch, os};
        Type[] _argTypes = new Type[]{Architecture.class, OperatingSystem.class};
        final ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "build", _args, _argTypes, _opts);
        return new ClientStream<File, File, byte[]>(){

            @Override
            public ListenableFuture<Void> send(final File item) {
                final Class<File> type = File.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.send(item, type);
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> close() {
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.closeSend();
                    }
                }));
            }

            @Override
            public ListenableFuture<File> recv() {
                final Class<File> recvType = File.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, File>(){

                    public ListenableFuture<File> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.recv(recvType), (Function)new Function<Object, File>(){

                            public File apply(Object result) {
                                return (File)result;
                            }
                        });
                    }
                }));
            }

            @Override
            public ListenableFuture<byte[]> finish() {
                final Type[] resultTypes = new Type[]{byte[].class};
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, byte[]>(){

                    public ListenableFuture<byte[]> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.finish(resultTypes), (Function)new Function<Object[], byte[]>(){

                            public byte[] apply(Object[] _results) {
                                return (byte[])_results[0];
                            }
                        });
                    }
                }));
            }
        };
    }

    @Override
    public ListenableFuture<Description> describe(VContext _context, String name) {
        return this.describe(_context, name, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Description> describe(VContext _context, String name, Options _opts) {
        return this.describe(_context, name, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Description> describe(VContext _context, String name, RpcOptions _opts) {
        Object[] _args = new Object[]{name};
        Type[] _argTypes = new Type[]{String.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "describe", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Description>(){

            public ListenableFuture<Description> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{Description.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Description>(){

                    public Description apply(Object[] _results) {
                        return (Description)_results[0];
                    }
                });
            }
        }));
    }
}

