/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.appcycle;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.services.appcycle.AppCycleServer;
import io.v.v23.services.appcycle.Task;
import io.v.v23.vdl.ServerSendStream;
import io.v.v23.vdl.ServerStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class AppCycleServerWrapper {
    private final AppCycleServer server;

    public AppCycleServerWrapper(AppCycleServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        methods.add(new Method("stop", "// Stop initiates shutdown of the server.  It streams back periodic// updates to give the client an idea of how the shutdown is// progressing.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        tags = new ArrayList();
        methods.add(new Method("forceStop", "// ForceStop tells the server to shut down right away.  It can be issued// while a Stop is outstanding if for example the client does not want// to wait any longer.", inArgs, outArgs, null, null, tags));
        return new Interface("AppCycle", "io.v.v23.services.appcycle", "// AppCycle interfaces with the process running a vanadium runtime.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("forceStop".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"forceStop\": %s", e.getMessage()));
            }
        }
        if ("stop".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"stop\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<Void> stop(VContext _ctx, final StreamServerCall _call) {
        ServerStream<Task, Void> _stream = new ServerStream<Task, Void>(){

            @Override
            public ListenableFuture<Void> send(Task _item) {
                Class<Task> _type = Task.class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<Void> recv() {
                Class<Void> _type = Void.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, Void>(){

                    public Void apply(Object result) {
                        return (Void)result;
                    }
                });
            }
        };
        return this.server.stop(_ctx, _call, (ServerSendStream<Task>)_stream);
    }

    public ListenableFuture<Void> forceStop(VContext _ctx, StreamServerCall _call) {
        return this.server.forceStop(_ctx, _call);
    }
}

