/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.security.access;

import io.v.v23.context.VContext;
import io.v.v23.security.Authorizer;
import io.v.v23.security.BlessingPattern;
import io.v.v23.security.Call;
import io.v.v23.security.access.WireAccessList;
import io.v.v23.verror.VException;
import java.util.List;

public class AccessList
extends WireAccessList
implements Authorizer {
    private static final long serialVersionUID = 1L;
    private final long nativeRef;

    private native long nativeCreate() throws VException;

    private native boolean nativeIncludes(long var1, String[] var3) throws VException;

    private native void nativeAuthorize(long var1, VContext var3, Call var4);

    private native void nativeFinalize(long var1);

    public AccessList(List<BlessingPattern> in, List<String> notIn) {
        super(in, notIn);
        try {
            this.nativeRef = this.nativeCreate();
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't create native AccessList", e);
        }
    }

    AccessList(WireAccessList wire) {
        this(wire.getIn(), wire.getNotIn());
    }

    public boolean includes(String ... blessings) {
        try {
            return this.nativeIncludes(this.nativeRef, blessings);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't test for access list inclusion", e);
        }
    }

    @Override
    public void authorize(VContext context, Call call) throws VException {
        this.nativeAuthorize(this.nativeRef, context, call);
    }

    protected void finalize() {
        this.nativeFinalize(this.nativeRef);
    }
}

