/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.security;

import com.google.common.collect.ImmutableList;
import io.v.v23.context.VContext;
import io.v.v23.security.Authorizer;
import io.v.v23.security.BlessingRoots;
import io.v.v23.security.BlessingStore;
import io.v.v23.security.Blessings;
import io.v.v23.security.Call;
import io.v.v23.security.CallParams;
import io.v.v23.security.CallParamsImpl;
import io.v.v23.security.Caveat;
import io.v.v23.security.CaveatDescriptor;
import io.v.v23.security.Constants;
import io.v.v23.security.CryptoUtil;
import io.v.v23.security.ECDSASigner;
import io.v.v23.security.VPrincipal;
import io.v.v23.security.VPrincipalImpl;
import io.v.v23.security.VSignature;
import io.v.v23.security.VSigner;
import io.v.v23.security.access.Permissions;
import io.v.v23.security.access.PermissionsAuthorizer;
import io.v.v23.verror.VException;
import io.v.v23.vom.VomUtil;
import java.lang.reflect.Type;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import org.joda.time.DateTime;

public class VSecurity {
    private static native String[] nativeGetRemoteBlessingNames(VContext var0, Call var1) throws VException;

    private static native String[] nativeGetLocalBlessingNames(VContext var0, Call var1) throws VException;

    private static native String[] nativeGetBlessingNames(VPrincipal var0, Blessings var1) throws VException;

    private static native String[] nativeGetSigningBlessingNames(VContext var0, VPrincipal var1, Blessings var2) throws VException;

    private static native void nativeAddToRoots(VPrincipal var0, Blessings var1) throws VException;

    public static VSigner newSigner(PrivateKey privKey, ECPublicKey pubKey) {
        return new ECDSASigner(privKey, pubKey);
    }

    public static VSigner newInMemorySigner() throws VException {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC");
            keyGen.initialize(256);
            KeyPair keyPair = keyGen.generateKeyPair();
            PrivateKey privKey = keyPair.getPrivate();
            ECPublicKey pubKey = (ECPublicKey)keyPair.getPublic();
            return new ECDSASigner(privKey, pubKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new VException("Couldn't mint private key: " + e.getMessage());
        }
    }

    public static VPrincipal newPrincipal() throws VException {
        return VPrincipalImpl.create();
    }

    public static VPrincipal newPrincipal(VSigner signer) throws VException {
        return VPrincipalImpl.create(signer);
    }

    public static VPrincipal newPrincipal(VSigner signer, BlessingStore store, BlessingRoots roots) throws VException {
        return VPrincipalImpl.create(signer, store, roots);
    }

    public static VPrincipal newPersistentPrincipal(String passphrase, String dir) throws VException {
        return VPrincipalImpl.createPersistent(passphrase, dir);
    }

    public static VPrincipal newPersistentPrincipal(VSigner signer, String dir) throws VException {
        return VPrincipalImpl.createPersistent(signer, dir);
    }

    public static Blessings unionOfBlessings(Blessings ... blessings) throws VException {
        return Blessings.createUnion(blessings);
    }

    public static String[] getRemoteBlessingNames(VContext context, Call call) {
        try {
            return VSecurity.nativeGetRemoteBlessingNames(context, call);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get blessings for call", e);
        }
    }

    public static String[] getLocalBlessingNames(VContext context, Call call) {
        try {
            return VSecurity.nativeGetLocalBlessingNames(context, call);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get blessings for call", e);
        }
    }

    public static String[] getBlessingNames(VPrincipal principal, Blessings blessings) {
        try {
            return VSecurity.nativeGetBlessingNames(principal, blessings);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get blessing names", e);
        }
    }

    public static String[] getSigningBlessingNames(VContext context, VPrincipal principal, Blessings blessings) {
        try {
            return VSecurity.nativeGetSigningBlessingNames(context, principal, blessings);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get signing blessing names", e);
        }
    }

    public static Caveat newCaveat(CaveatDescriptor desc, Object param) throws VException {
        byte[] paramVOM = VomUtil.encode(param, desc.getParamType().getTypeObject());
        return new Caveat(desc.getId(), paramVOM);
    }

    public static Caveat newExpiryCaveat(DateTime time) throws VException {
        return VSecurity.newCaveat(Constants.EXPIRY_CAVEAT, time);
    }

    public static Caveat newMethodCaveat(String method, String ... additionalMethods) throws VException {
        ImmutableList methods = ImmutableList.builder().add((Object)method).add((Object[])additionalMethods).build();
        return VSecurity.newCaveat(Constants.METHOD_CAVEAT, methods);
    }

    public static Caveat newUnconstrainedUseCaveat() throws VException {
        return VSecurity.newCaveat(Constants.CONST_CAVEAT, true);
    }

    public static Call newCall(CallParams params) {
        return new CallParamsImpl(params);
    }

    public static Authorizer newPermissionsAuthorizer(Permissions acls, Type type) throws VException {
        return PermissionsAuthorizer.create(acls, type);
    }

    private static native Authorizer nativeCreateAuthorizer(int var0, ECPublicKey var1);

    public static Authorizer newAllowEveryoneAuthorizer() {
        return VSecurity.nativeCreateAuthorizer(AuthorizerTypes.ALLOW_EVERYONE_AUTHORIZER.ordinal(), null);
    }

    public static Authorizer newEndpointAuthorizer() {
        return VSecurity.nativeCreateAuthorizer(AuthorizerTypes.ENDPOINT_AUTHORIZER.ordinal(), null);
    }

    public static Authorizer newDefaultAuthorizer() {
        return VSecurity.nativeCreateAuthorizer(AuthorizerTypes.DEFAULT_AUTHORIZER.ordinal(), null);
    }

    public static Authorizer newPublicKeyAuthorizer(ECPublicKey key) {
        return VSecurity.nativeCreateAuthorizer(AuthorizerTypes.PUBLIC_KEY_AUTHORIZER.ordinal(), key);
    }

    public static void verifySignature(VSignature sig, ECPublicKey key, byte[] message) throws VException {
        String vHashAlgorithm = sig.getHash().getValue();
        String verifyAlgorithm = CryptoUtil.javaSigningAlgorithm(vHashAlgorithm);
        try {
            message = CryptoUtil.messageDigest(vHashAlgorithm, message, sig.getPurpose(), key);
            byte[] jSig = CryptoUtil.javaSignature(sig);
            Signature verifier = Signature.getInstance(verifyAlgorithm);
            verifier.initVerify(key);
            verifier.update(message);
            if (!verifier.verify(jSig)) {
                throw new VException("Signature doesn't verify.");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new VException("Verifying algorithm " + verifyAlgorithm + " not supported by the runtime: " + e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new VException("Invalid private key: " + e.getMessage());
        }
        catch (SignatureException e) {
            throw new VException("Invalid signing data [ " + Arrays.toString(message) + " ]: " + e.getMessage());
        }
    }

    public static void addToRoots(VPrincipal principal, Blessings blessings) throws VException {
        VSecurity.nativeAddToRoots(principal, blessings);
    }

    private VSecurity() {
    }

    private static enum AuthorizerTypes {
        ALLOW_EVERYONE_AUTHORIZER,
        ENDPOINT_AUTHORIZER,
        DEFAULT_AUTHORIZER,
        PUBLIC_KEY_AUTHORIZER;

    }
}

