/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.security;

import io.v.v23.security.BlessingRoots;
import io.v.v23.security.BlessingStore;
import io.v.v23.security.Blessings;
import io.v.v23.security.Caveat;
import io.v.v23.security.VPrincipal;
import io.v.v23.security.VSignature;
import io.v.v23.security.VSigner;
import io.v.v23.verror.VException;
import java.security.interfaces.ECPublicKey;

class VPrincipalImpl
implements VPrincipal {
    private final long nativeRef;
    private final VSigner signer;
    private final BlessingStore store;
    private final BlessingRoots roots;

    private static native VPrincipalImpl nativeCreate() throws VException;

    private static native VPrincipalImpl nativeCreateForSigner(VSigner var0) throws VException;

    private static native VPrincipalImpl nativeCreateForAll(VSigner var0, BlessingStore var1, BlessingRoots var2) throws VException;

    private static native VPrincipalImpl nativeCreatePersistent(String var0, String var1) throws VException;

    private static native VPrincipalImpl nativeCreatePersistentForSigner(VSigner var0, String var1) throws VException;

    static VPrincipalImpl create() throws VException {
        return VPrincipalImpl.nativeCreate();
    }

    static VPrincipalImpl create(VSigner signer) throws VException {
        return VPrincipalImpl.nativeCreateForSigner(signer);
    }

    static VPrincipalImpl create(VSigner signer, BlessingStore store, BlessingRoots roots) throws VException {
        return VPrincipalImpl.nativeCreateForAll(signer, store, roots);
    }

    static VPrincipalImpl createPersistent(String passphrase, String dir) throws VException {
        return VPrincipalImpl.nativeCreatePersistent(passphrase, dir);
    }

    static VPrincipalImpl createPersistent(VSigner signer, String dir) throws VException {
        return VPrincipalImpl.nativeCreatePersistentForSigner(signer, dir);
    }

    private native Blessings nativeBless(long var1, ECPublicKey var3, Blessings var4, String var5, Caveat var6, Caveat[] var7) throws VException;

    private native Blessings nativeBlessSelf(long var1, String var3, Caveat[] var4) throws VException;

    private native VSignature nativeSign(long var1, byte[] var3) throws VException;

    private native ECPublicKey nativePublicKey(long var1) throws VException;

    private native BlessingStore nativeBlessingStore(long var1) throws VException;

    private native BlessingRoots nativeRoots(long var1) throws VException;

    private native void nativeFinalize(long var1);

    private VPrincipalImpl(long nativeRef, VSigner signer, BlessingStore store, BlessingRoots roots) {
        this.nativeRef = nativeRef;
        this.signer = signer;
        this.store = store;
        this.roots = roots;
    }

    @Override
    public Blessings bless(ECPublicKey key, Blessings with, String extension, Caveat caveat, Caveat ... additionalCaveats) throws VException {
        return this.nativeBless(this.nativeRef, key, with, extension, caveat, additionalCaveats);
    }

    @Override
    public Blessings blessSelf(String name, Caveat ... caveats) throws VException {
        return this.nativeBlessSelf(this.nativeRef, name, caveats);
    }

    @Override
    public VSignature sign(byte[] message) throws VException {
        if (this.signer != null) {
            byte[] purpose = "S1".getBytes();
            return this.signer.sign(purpose, message);
        }
        return this.nativeSign(this.nativeRef, message);
    }

    @Override
    public ECPublicKey publicKey() {
        if (this.signer != null) {
            return this.signer.publicKey();
        }
        try {
            return this.nativePublicKey(this.nativeRef);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get public key", e);
        }
    }

    @Override
    public BlessingStore blessingStore() {
        if (this.store != null) {
            return this.store;
        }
        try {
            return this.nativeBlessingStore(this.nativeRef);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get Blessing Store", e);
        }
    }

    @Override
    public BlessingRoots roots() {
        if (this.roots != null) {
            return this.roots;
        }
        try {
            return this.nativeRoots(this.nativeRef);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get Blessing Store", e);
        }
    }

    private long nativeRef() {
        return this.nativeRef;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.nativeRef == ((VPrincipalImpl)other).nativeRef;
    }

    public int hashCode() {
        return Long.valueOf(this.nativeRef).hashCode();
    }

    protected void finalize() {
        this.nativeFinalize(this.nativeRef);
    }
}

