/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.security;

import io.v.v23.context.VContext;
import io.v.v23.security.Call;
import io.v.v23.security.Caveat;
import io.v.v23.security.CaveatDescriptor;
import io.v.v23.security.CaveatNotRegisteredException;
import io.v.v23.security.CaveatValidator;
import io.v.v23.uniqueid.Id;
import io.v.v23.verror.VException;
import io.v.v23.vom.VomUtil;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CaveatRegistry {
    private static final Map<Id, RegistryEntry> validators = new HashMap<Id, RegistryEntry>();
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();

    public static void register(CaveatDescriptor desc, CaveatValidator validator) throws VException {
        String registerer = CaveatRegistry.getRegisterer();
        lock.writeLock().lock();
        RegistryEntry existing = validators.get(desc.getId());
        if (existing != null) {
            lock.writeLock().unlock();
            throw new VException(String.format("Caveat with UUID %s registered twice. Once with (%s, validator=%s) from %s, once with (%s, validator=%s) from %s", desc.getId(), existing.getDescriptor().getParamType(), existing.getValidator(), existing.getRegisterer(), desc.getParamType(), validator, registerer));
        }
        Type paramType = null;
        RegistryEntry entry = new RegistryEntry(desc, validator, paramType, registerer);
        validators.put(desc.getId(), entry);
        lock.writeLock().unlock();
    }

    public static void validate(VContext context, Call call, Caveat caveat) throws VException {
        RegistryEntry entry = CaveatRegistry.lookup(caveat.getId());
        if (entry == null) {
            throw new CaveatNotRegisteredException(null, caveat.getId());
        }
        Object param = null;
        try {
            param = VomUtil.decode(caveat.getParamVom());
        }
        catch (VException e) {
            throw new VException(e.getMessage());
        }
        entry.validator.validate(context, call, param);
    }

    private static RegistryEntry lookup(Id id) {
        lock.readLock().lock();
        RegistryEntry entry = validators.get(id);
        lock.readLock().unlock();
        return entry;
    }

    private static String getRegisterer() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack == null || stack.length < 2) {
            return "";
        }
        StackTraceElement registerer = stack[stack.length - 2];
        return String.format("%s:%d", registerer.getFileName(), registerer.getLineNumber());
    }

    private CaveatRegistry() {
    }

    private static class RegistryEntry {
        CaveatDescriptor desc;
        CaveatValidator validator;
        Type paramType;
        String registerer;

        RegistryEntry(CaveatDescriptor desc, CaveatValidator validator, Type paramType, String registerer) {
            this.desc = desc;
            this.validator = validator;
            this.paramType = paramType;
            this.registerer = registerer;
        }

        CaveatDescriptor getDescriptor() {
            return this.desc;
        }

        CaveatValidator getValidator() {
            return this.validator;
        }

        Type getParamType() {
            return this.paramType;
        }

        String getRegisterer() {
            return this.registerer;
        }
    }
}

