/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.security;

import com.google.common.collect.ImmutableMap;
import io.v.v23.context.VContext;
import io.v.v23.security.Blessings;
import io.v.v23.security.Discharge;
import io.v.v23.security.VPrincipal;
import io.v.v23.vdl.VdlValue;
import java.util.Map;
import org.joda.time.DateTime;

public class CallParams {
    final CallParams parent;
    private DateTime timestamp;
    private String method;
    private VdlValue[] methodTags;
    private String suffix;
    private Map<String, Discharge> localDischarges;
    private Map<String, Discharge> remoteDischarges;
    private String localEndpoint;
    private String remoteEndpoint;
    private VPrincipal principal;
    private Blessings localBlessings;
    private Blessings remoteBlessings;
    private VContext context;

    public CallParams() {
        this.parent = null;
    }

    private CallParams(CallParams parent) {
        this.parent = parent;
    }

    public CallParams withTimestamp(DateTime time) {
        CallParams ret = new CallParams(this);
        ret.timestamp = time;
        return ret;
    }

    public CallParams withMethod(String method) {
        CallParams ret = new CallParams(this);
        ret.method = method;
        return ret;
    }

    public CallParams withMethodTags(VdlValue ... tags) {
        CallParams ret = new CallParams(this);
        ret.methodTags = tags;
        return ret;
    }

    public CallParams withSuffix(String suffix) {
        CallParams ret = new CallParams(this);
        ret.suffix = suffix;
        return ret;
    }

    public CallParams withLocalDischarges(Map<String, Discharge> localDischarges) {
        CallParams ret = new CallParams(this);
        ret.localDischarges = ImmutableMap.copyOf(localDischarges);
        return ret;
    }

    public CallParams withRemoteDischarges(Map<String, Discharge> remoteDischarges) {
        CallParams ret = new CallParams(this);
        ret.remoteDischarges = ImmutableMap.copyOf(remoteDischarges);
        return ret;
    }

    public CallParams withLocalEndpoint(String endpoint) {
        CallParams ret = new CallParams(this);
        ret.localEndpoint = endpoint;
        return ret;
    }

    public CallParams withRemoteEndpoint(String endpoint) {
        CallParams ret = new CallParams(this);
        ret.remoteEndpoint = endpoint;
        return ret;
    }

    public CallParams withLocalPrincipal(VPrincipal principal) {
        CallParams ret = new CallParams(this);
        ret.principal = principal;
        return ret;
    }

    public CallParams withLocalBlessings(Blessings blessings) {
        CallParams ret = new CallParams(this);
        ret.localBlessings = blessings;
        return ret;
    }

    public CallParams withRemoteBlessings(Blessings blessings) {
        CallParams ret = new CallParams(this);
        ret.remoteBlessings = blessings;
        return ret;
    }

    public CallParams withContext(VContext context) {
        CallParams ret = new CallParams(this);
        ret.context = context;
        return ret;
    }

    public DateTime getTimestamp() {
        if (this.timestamp != null) {
            return this.timestamp;
        }
        if (this.parent != null) {
            return this.parent.getTimestamp();
        }
        return null;
    }

    public String getMethod() {
        if (this.method != null) {
            return this.method;
        }
        if (this.parent != null) {
            return this.parent.getMethod();
        }
        return null;
    }

    public VdlValue[] getMethodTags() {
        if (this.methodTags != null) {
            return this.methodTags;
        }
        if (this.parent != null) {
            return this.parent.getMethodTags();
        }
        return null;
    }

    public String getSuffix() {
        if (this.suffix != null) {
            return this.suffix;
        }
        if (this.parent != null) {
            return this.parent.getSuffix();
        }
        return null;
    }

    public Map<String, Discharge> getLocalDischarges() {
        return this.localDischarges;
    }

    public Map<String, Discharge> getRemoteDischarges() {
        return this.remoteDischarges;
    }

    public String getLocalEndpoint() {
        if (this.localEndpoint != null) {
            return this.localEndpoint;
        }
        if (this.parent != null) {
            return this.parent.getLocalEndpoint();
        }
        return null;
    }

    public String getRemoteEndpoint() {
        if (this.remoteEndpoint != null) {
            return this.remoteEndpoint;
        }
        if (this.parent != null) {
            return this.parent.getRemoteEndpoint();
        }
        return null;
    }

    public VPrincipal getLocalPrincipal() {
        if (this.principal != null) {
            return this.principal;
        }
        if (this.parent != null) {
            return this.parent.getLocalPrincipal();
        }
        return null;
    }

    public Blessings getLocalBlessings() {
        if (this.localBlessings != null) {
            return this.localBlessings;
        }
        if (this.parent != null) {
            return this.parent.getLocalBlessings();
        }
        return null;
    }

    public Blessings getRemoteBlessings() {
        if (this.remoteBlessings != null) {
            return this.remoteBlessings;
        }
        if (this.parent != null) {
            return this.parent.getRemoteBlessings();
        }
        return null;
    }

    public VContext getContext() {
        if (this.context != null) {
            return this.context;
        }
        if (this.parent != null) {
            return this.parent.getContext();
        }
        return null;
    }
}

