/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.security;

import io.v.v23.security.Blessings;
import io.v.v23.security.Call;
import io.v.v23.security.Discharge;
import io.v.v23.security.VPrincipal;
import io.v.v23.vdl.VdlValue;
import io.v.v23.verror.VException;
import java.util.Map;
import org.joda.time.DateTime;

class CallImpl
implements Call {
    private final long nativeRef;

    private native DateTime nativeTimestamp(long var1) throws VException;

    private native String nativeMethod(long var1);

    private native VdlValue[] nativeMethodTags(long var1) throws VException;

    private native String nativeSuffix(long var1);

    private native Map<String, Discharge> nativeLocalDischarges(long var1);

    private native Map<String, Discharge> nativeRemoteDischarges(long var1);

    private native String nativeLocalEndpoint(long var1);

    private native String nativeRemoteEndpoint(long var1);

    private native VPrincipal nativeLocalPrincipal(long var1) throws VException;

    private native Blessings nativeLocalBlessings(long var1) throws VException;

    private native Blessings nativeRemoteBlessings(long var1) throws VException;

    private native void nativeFinalize(long var1);

    CallImpl(long nativeRef) {
        this.nativeRef = nativeRef;
    }

    @Override
    public DateTime timestamp() {
        try {
            return this.nativeTimestamp(this.nativeRef);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get timestamp", e);
        }
    }

    @Override
    public String method() {
        return this.nativeMethod(this.nativeRef);
    }

    @Override
    public VdlValue[] methodTags() {
        try {
            VdlValue[] tags = this.nativeMethodTags(this.nativeRef);
            return tags != null ? tags : new VdlValue[]{};
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get method tags", e);
        }
    }

    @Override
    public String suffix() {
        return this.nativeSuffix(this.nativeRef);
    }

    @Override
    public Map<String, Discharge> localDischarges() {
        return this.nativeLocalDischarges(this.nativeRef);
    }

    @Override
    public Map<String, Discharge> remoteDischarges() {
        return this.nativeRemoteDischarges(this.nativeRef);
    }

    @Override
    public String localEndpoint() {
        return this.nativeLocalEndpoint(this.nativeRef);
    }

    @Override
    public String remoteEndpoint() {
        return this.nativeRemoteEndpoint(this.nativeRef);
    }

    @Override
    public VPrincipal localPrincipal() {
        try {
            return this.nativeLocalPrincipal(this.nativeRef);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get local principal", e);
        }
    }

    @Override
    public Blessings localBlessings() {
        try {
            return this.nativeLocalBlessings(this.nativeRef);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get local blessings", e);
        }
    }

    @Override
    public Blessings remoteBlessings() {
        try {
            return this.nativeRemoteBlessings(this.nativeRef);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get remote blessings", e);
        }
    }

    protected void finalize() {
        this.nativeFinalize(this.nativeRef);
    }

    private long nativeRef() {
        return this.nativeRef;
    }
}

