/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.security;

import com.google.common.base.Joiner;
import io.v.v23.security.VCertificate;
import io.v.v23.security.WireBlessings;
import io.v.v23.verror.VException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.List;

public final class Blessings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long nativeRef;
    private volatile WireBlessings wire;

    private static native long nativeCreate(WireBlessings var0) throws VException;

    private static native Blessings nativeCreateUnion(Blessings[] var0) throws VException;

    public static Blessings create(WireBlessings wire) {
        try {
            return new Blessings(Blessings.nativeCreate(wire), wire);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't create blessings from WireBlessings", e);
        }
    }

    static Blessings createUnion(Blessings ... blessings) throws VException {
        return Blessings.nativeCreateUnion(blessings);
    }

    private native ECPublicKey nativePublicKey(long var1) throws VException;

    private native Blessings nativeSigningBlessings(long var1) throws VException;

    private native WireBlessings nativeWireFormat(long var1) throws VException;

    private native void nativeFinalize(long var1);

    private Blessings(long nativeRef) {
        this.nativeRef = nativeRef;
    }

    private Blessings(long nativeRef, WireBlessings wire) {
        this.nativeRef = nativeRef;
        this.wire = wire;
    }

    public ECPublicKey publicKey() {
        try {
            return this.nativePublicKey(this.nativeRef);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get public key", e);
        }
    }

    public Blessings signingBlessings() {
        try {
            return this.nativeSigningBlessings(this.nativeRef);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get signing blessings", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WireBlessings wireFormat() {
        Blessings blessings = this;
        synchronized (blessings) {
            if (this.wire != null) {
                return this.wire;
            }
        }
        WireBlessings ret = null;
        try {
            ret = this.nativeWireFormat(this.nativeRef);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get wire blessings representation.", e);
        }
        Blessings blessings2 = this;
        synchronized (blessings2) {
            if (this.wire == null) {
                this.wire = ret;
            }
        }
        return ret;
    }

    public boolean isEmpty() {
        return this.wireFormat().getCertificateChains().isEmpty();
    }

    public List<List<VCertificate>> getCertificateChains() {
        return this.wireFormat().getCertificateChains();
    }

    private long nativeRef() {
        return this.nativeRef;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.wireFormat());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.wire = (WireBlessings)in.readObject();
        try {
            this.nativeRef = Blessings.nativeCreate(this.wire);
        }
        catch (VException e) {
            throw new IOException("Couldn't create native blessings.", e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Blessings)) {
            return false;
        }
        Blessings other = (Blessings)obj;
        return this.wireFormat().equals(other.wireFormat());
    }

    public int hashCode() {
        return this.wireFormat().hashCode();
    }

    public String toString() {
        ArrayList<String> chains = new ArrayList<String>(this.getCertificateChains().size());
        for (List<VCertificate> certificateChain : this.getCertificateChains()) {
            ArrayList<String> certificateNames = new ArrayList<String>(certificateChain.size());
            for (VCertificate certificate : certificateChain) {
                String e = certificate.getExtension().replaceAll("/", ":");
                certificateNames.add(e);
            }
            chains.add(Joiner.on((String)":").join(certificateNames));
        }
        return Joiner.on((String)",").join(chains);
    }

    protected void finalize() {
        this.nativeFinalize(this.nativeRef);
    }
}

