/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.security;

import io.v.v23.security.BlessingPattern;
import io.v.v23.security.BlessingStore;
import io.v.v23.security.Blessings;
import io.v.v23.security.Caveat;
import io.v.v23.security.Discharge;
import io.v.v23.security.DischargeImpetus;
import io.v.v23.verror.VException;
import java.security.interfaces.ECPublicKey;
import java.util.List;
import java.util.Map;

class BlessingStoreImpl
implements BlessingStore {
    private final long nativeRef;

    private native Blessings nativeSet(long var1, Blessings var3, BlessingPattern var4) throws VException;

    private native Blessings nativeForPeer(long var1, String[] var3) throws VException;

    private native void nativeSetDefaultBlessings(long var1, Blessings var3) throws VException;

    private native Blessings nativeDefaultBlessings(long var1) throws VException;

    private native ECPublicKey nativePublicKey(long var1) throws VException;

    private native Map<BlessingPattern, Blessings> nativePeerBlessings(long var1) throws VException;

    private native void nativeCacheDischarge(long var1, Discharge var3, Caveat var4, DischargeImpetus var5);

    private native void nativeClearDischarges(long var1, Object[] var3);

    private native Discharge nativeDischarge(long var1, Caveat var3, DischargeImpetus var4);

    private native String nativeDebugString(long var1);

    private native String nativeToString(long var1);

    private native void nativeFinalize(long var1);

    private BlessingStoreImpl(long nativeRef) {
        this.nativeRef = nativeRef;
    }

    @Override
    public Blessings set(Blessings blessings, BlessingPattern forPeers) throws VException {
        return this.nativeSet(this.nativeRef, blessings, forPeers);
    }

    @Override
    public Blessings forPeer(String ... peerBlessings) {
        try {
            return this.nativeForPeer(this.nativeRef, peerBlessings);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get blessings for peers", e);
        }
    }

    @Override
    public void setDefaultBlessings(Blessings blessings) throws VException {
        this.nativeSetDefaultBlessings(this.nativeRef, blessings);
    }

    @Override
    public Blessings defaultBlessings() {
        try {
            return this.nativeDefaultBlessings(this.nativeRef);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get default blessings", e);
        }
    }

    @Override
    public ECPublicKey publicKey() {
        try {
            return this.nativePublicKey(this.nativeRef);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get public key", e);
        }
    }

    @Override
    public Map<BlessingPattern, Blessings> peerBlessings() {
        try {
            return this.nativePeerBlessings(this.nativeRef);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get peer blessings", e);
        }
    }

    @Override
    public void cacheDischarge(Discharge discharge, Caveat caveat, DischargeImpetus impetus) {
        this.nativeCacheDischarge(this.nativeRef, discharge, caveat, impetus);
    }

    @Override
    public void clearDischarges(List<Discharge> discharges) {
        this.nativeClearDischarges(this.nativeRef, discharges.toArray());
    }

    @Override
    public Discharge discharge(Caveat caveat, DischargeImpetus impetus) {
        return this.nativeDischarge(this.nativeRef, caveat, impetus);
    }

    @Override
    public String debugString() {
        return this.nativeDebugString(this.nativeRef);
    }

    public String toString() {
        return this.nativeToString(this.nativeRef);
    }

    protected void finalize() {
        this.nativeFinalize(this.nativeRef);
    }
}

