/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.rpc;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import io.v.v23.VFutures;
import io.v.v23.VIterable;
import io.v.v23.rpc.Stream;
import io.v.v23.verror.CanceledException;
import io.v.v23.verror.EndOfFileException;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.Iterator;

public class StreamIterable<T>
implements VIterable<T> {
    private final Stream stream;
    private final Type type;
    private boolean isCreated;
    private volatile VException error;

    public StreamIterable(Stream stream, Type type) {
        this.stream = stream;
        this.type = type;
    }

    @Override
    public synchronized Iterator<T> iterator() {
        Preconditions.checkState((!this.isCreated ? 1 : 0) != 0, (Object)"Can only create one iterator.");
        this.isCreated = true;
        return new AbstractIterator<T>(){

            protected T computeNext() {
                try {
                    return VFutures.sync(StreamIterable.this.stream.recv(StreamIterable.this.type));
                }
                catch (EndOfFileException e) {
                    return this.endOfData();
                }
                catch (CanceledException e) {
                    return this.endOfData();
                }
                catch (VException e) {
                    StreamIterable.this.error = e;
                    return this.endOfData();
                }
            }
        };
    }

    @Override
    public VException error() {
        return this.error;
    }
}

