/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.rpc;

import io.v.impl.google.naming.EndpointImpl;
import io.v.v23.naming.Endpoint;
import io.v.v23.rpc.ListenSpec;
import io.v.v23.rpc.PublisherEntry;
import io.v.v23.rpc.ServerState;
import io.v.v23.verror.VException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ServerStatus {
    private final ServerState state;
    private final boolean servesMountTable;
    private final PublisherEntry[] entries;
    private final String[] endpoints;
    private final Map<ListenSpec.Address, VException> lnErrors;
    private final Map<String, VException> proxyErrors;

    public ServerStatus(ServerState state, boolean servesMountTable, PublisherEntry[] entries, String[] endpoints, Map<ListenSpec.Address, VException> lnErrors, Map<String, VException> proxyErrors) {
        this.state = state;
        this.servesMountTable = servesMountTable;
        this.entries = entries == null ? new PublisherEntry[]{} : Arrays.copyOf(entries, entries.length);
        this.endpoints = endpoints == null ? new String[]{} : Arrays.copyOf(endpoints, endpoints.length);
        this.lnErrors = lnErrors;
        this.proxyErrors = proxyErrors;
    }

    public ServerState getState() {
        return this.state;
    }

    public boolean servesMountTable() {
        return this.servesMountTable;
    }

    public PublisherEntry[] getPublisherStatus() {
        return Arrays.copyOf(this.entries, this.entries.length);
    }

    public Endpoint[] getEndpoints() {
        Endpoint[] result = new Endpoint[this.endpoints.length];
        for (int i = 0; i < this.endpoints.length; ++i) {
            result[i] = EndpointImpl.fromString(this.endpoints[i]);
        }
        return result;
    }

    public Map<ListenSpec.Address, VException> getListenErrors() {
        return new HashMap<ListenSpec.Address, VException>(this.lnErrors);
    }

    public Map<String, VException> getProxyErrors() {
        return new HashMap<String, VException>(this.proxyErrors);
    }

    public String toString() {
        return String.format("State: %s, MountTable: %s, Mounts: %s, Endpoints: %s, ListenErrors: %s, ProxyErrors: %s", new Object[]{this.state, this.servesMountTable, Arrays.toString(this.entries), Arrays.toString(this.endpoints), this.lnErrors.toString(), this.proxyErrors.toString()});
    }
}

