/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.rpc;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.v.v23.V;
import io.v.v23.context.VContext;
import io.v.v23.naming.GlobReply;
import io.v.v23.rpc.Globber;
import io.v.v23.rpc.Invoker;
import io.v.v23.rpc.ServerCall;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.vdl.MultiReturn;
import io.v.v23.vdl.ServerSendStream;
import io.v.v23.vdl.VServer;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.CanceledException;
import io.v.v23.verror.VException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public final class ReflectInvoker
implements Invoker {
    private static Map<Class<?>, ClassInfo> serverWrapperClasses = new HashMap();
    private final Map<String, ServerMethod> invokableMethods = new HashMap<String, ServerMethod>();
    private final Map<Object, java.lang.reflect.Method> signatureMethods = new HashMap<Object, java.lang.reflect.Method>();
    private final Object server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReflectInvoker(Object obj) throws VException {
        if (obj == null) {
            throw new VException("Can't create ReflectInvoker with a null object.");
        }
        this.server = obj;
        List<Object> serverWrappers = this.wrapServer(obj);
        for (Object wrapper : serverWrappers) {
            ClassInfo cInfo;
            Class<?> c = wrapper.getClass();
            ReflectInvoker reflectInvoker = this;
            synchronized (reflectInvoker) {
                cInfo = serverWrapperClasses.get(c);
            }
            if (cInfo == null) {
                cInfo = new ClassInfo(c);
                reflectInvoker = this;
                synchronized (reflectInvoker) {
                    serverWrapperClasses.put(c, cInfo);
                }
            }
            Map<String, java.lang.reflect.Method> methods = cInfo.getMethods();
            java.lang.reflect.Method tagGetter = methods.get("getMethodTags");
            java.lang.reflect.Method signatureMethod = methods.get("signature");
            if (signatureMethod != null) {
                this.signatureMethods.put(wrapper, signatureMethod);
            }
            for (Map.Entry<String, java.lang.reflect.Method> m : methods.entrySet()) {
                Type[] argTypes = m.getValue().getGenericParameterTypes();
                if (argTypes.length < 2 || argTypes[0] != VContext.class || argTypes[1] != StreamServerCall.class) continue;
                VdlValue[] tags = null;
                if (tagGetter != null) {
                    try {
                        tags = (VdlValue[])tagGetter.invoke(wrapper, m.getValue().getName());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException e) {
                        throw new VException(String.format("Error getting tag for method %s: %s", m.getKey(), e.getTargetException().getMessage()));
                    }
                }
                this.invokableMethods.put(m.getKey(), new ServerMethod(wrapper, m.getValue(), tags));
            }
        }
    }

    @Override
    public ListenableFuture<Object[]> invoke(final VContext ctx, final StreamServerCall call, final String method, final Object[] args) {
        Executor executor = V.getExecutor(ctx);
        if (executor == null) {
            return Futures.immediateFailedFuture((Throwable)new VException("NULL executor in context: did you derive server context from the context returned by V.init()?"));
        }
        try {
            final ServerMethod m = this.findMethod(method);
            final SettableFuture ret = SettableFuture.create();
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ctx.isCanceled()) {
                            ret.setException((Throwable)new CanceledException(ctx));
                            return;
                        }
                        Object[] allArgs = new Object[2 + args.length];
                        allArgs[0] = ctx;
                        allArgs[1] = call;
                        System.arraycopy(args, 0, allArgs, 2, args.length);
                        Object result = m.invoke(allArgs);
                        ret.set((Object)ReflectInvoker.prepareReply(m, result));
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        ret.setException((Throwable)new VException(String.format("Error invoking method %s: %s", method, e.getCause().toString())));
                    }
                }
            });
            return Futures.dereference((ListenableFuture)ret);
        }
        catch (VException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    private static ListenableFuture<Object[]> prepareReply(final ServerMethod m, Object resultFuture) {
        if (resultFuture == null) {
            return Futures.immediateFailedFuture((Throwable)new VException(String.format("Server method %s returned NULL ListenableFuture.", m.getReflectMethod().getName())));
        }
        if (!(resultFuture instanceof ListenableFuture)) {
            return Futures.immediateFailedFuture((Throwable)new VException(String.format("Server method %s didn't return a ListenableFuture.", m.getReflectMethod().getName())));
        }
        return Futures.transform((ListenableFuture)((ListenableFuture)resultFuture), (AsyncFunction)new AsyncFunction<Object, Object[]>(){

            public ListenableFuture<Object[]> apply(Object result) throws Exception {
                Type[] resultTypes = m.getResultTypes();
                switch (resultTypes.length) {
                    case 0: {
                        return Futures.immediateFuture((Object)new Object[0]);
                    }
                    case 1: {
                        return Futures.immediateFuture((Object)new Object[]{result});
                    }
                }
                Class returnType = (Class)m.getReturnType();
                Field[] fields = returnType.getFields();
                Object[] reply = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    try {
                        reply[i] = result != null ? fields[i].get(result) : null;
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new VException("Couldn't get field: " + e.getMessage());
                    }
                }
                return Futures.immediateFuture((Object)reply);
            }
        });
    }

    @Override
    public ListenableFuture<Interface[]> getSignature(VContext ctx) {
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        for (Map.Entry<Object, java.lang.reflect.Method> entry : this.signatureMethods.entrySet()) {
            try {
                interfaces.add((Interface)entry.getValue().invoke(entry.getKey(), new Object[0]));
            }
            catch (IllegalAccessException e) {
                return Futures.immediateFailedFuture((Throwable)new VException(String.format("Could not invoke signature method for server class %s: %s", this.server.getClass().getName(), e.toString())));
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return Futures.immediateFailedFuture((Throwable)new VException(String.format("Could not invoke signature method for server class %s: %s", this.server.getClass().getName(), e.toString())));
            }
        }
        return Futures.immediateFuture((Object)interfaces.toArray(new Interface[interfaces.size()]));
    }

    @Override
    public ListenableFuture<Method> getMethodSignature(VContext ctx, final String methodName) {
        return Futures.transform(this.getSignature(ctx), (AsyncFunction)new AsyncFunction<Interface[], Method>(){

            public ListenableFuture<Method> apply(Interface[] interfaces) throws Exception {
                for (Interface iface : interfaces) {
                    for (Method method : iface.getMethods()) {
                        if (!method.getName().equals(methodName)) continue;
                        return Futures.immediateFuture((Object)method);
                    }
                }
                throw new VException(String.format("Could not find method %s", methodName));
            }
        });
    }

    @Override
    public ListenableFuture<Type[]> getArgumentTypes(VContext ctx, String method) {
        try {
            return Futures.immediateFuture((Object)this.findMethod(method).getArgumentTypes());
        }
        catch (VException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    @Override
    public ListenableFuture<Type[]> getResultTypes(VContext ctx, String method) {
        try {
            return Futures.immediateFuture((Object)this.findMethod(method).getResultTypes());
        }
        catch (VException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    @Override
    public ListenableFuture<VdlValue[]> getMethodTags(VContext ctx, String method) {
        try {
            return Futures.immediateFuture((Object)this.findMethod(method).getTags());
        }
        catch (VException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    @Override
    public ListenableFuture<Void> glob(VContext ctx, ServerCall call, String pattern, ServerSendStream<GlobReply> stream) {
        if (this.server instanceof Globber) {
            return ((Globber)this.server).glob(ctx, call, pattern, stream);
        }
        return Futures.immediateFuture(null);
    }

    private ServerMethod findMethod(String method) throws VException {
        ServerMethod m = this.invokableMethods.get(method);
        if (m == null) {
            throw new VException(String.format("Couldn't find method \"%s\" in class %s", method, this.server.getClass().getCanonicalName()));
        }
        return m;
    }

    private List<Object> wrapServer(Object srv) throws VException {
        ArrayList<Object> stubs = new ArrayList<Object>();
        for (Class<?> iface : srv.getClass().getInterfaces()) {
            VServer vs = iface.getAnnotation(VServer.class);
            if (vs == null) continue;
            if (vs.serverWrapper().getConstructors().length != 1) {
                throw new RuntimeException("Expected ServerWrapper to only have a single constructor");
            }
            Constructor<?> constructor = vs.serverWrapper().getConstructors()[0];
            try {
                stubs.add(constructor.newInstance(srv));
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Invalid constructor. Problem instanciating.", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Invalid constructor. Illegal access.", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Invalid constructor. Problem invoking.", e);
            }
        }
        if (stubs.size() == 0) {
            throw new VException("Object does not implement a valid generated server interface.");
        }
        return stubs;
    }

    private static class ClassInfo {
        final Map<String, java.lang.reflect.Method> methods = new HashMap<String, java.lang.reflect.Method>();

        ClassInfo(Class<?> c) throws VException {
            java.lang.reflect.Method[] methodList = c.getDeclaredMethods();
            for (int i = 0; i < methodList.length; ++i) {
                java.lang.reflect.Method method = methodList[i];
                java.lang.reflect.Method oldval = null;
                try {
                    oldval = this.methods.put(method.getName(), method);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (oldval == null) continue;
                throw new VException("Overloading of method " + method.getName() + " not allowed on server wrapper");
            }
        }

        Map<String, java.lang.reflect.Method> getMethods() {
            return this.methods;
        }
    }

    private static final class ServerMethod {
        private final Object wrappedServer;
        private final java.lang.reflect.Method method;
        private final VdlValue[] tags;
        private final Type[] argTypes;
        private final Type[] resultTypes;
        private final Type returnType;

        ServerMethod(Object wrappedServer, java.lang.reflect.Method method, VdlValue[] tags) throws VException {
            this.wrappedServer = wrappedServer;
            this.method = method;
            this.tags = tags != null ? Arrays.copyOf(tags, tags.length) : new VdlValue[]{};
            Type[] args = method.getGenericParameterTypes();
            this.argTypes = Arrays.copyOfRange(args, 2, args.length);
            Type returnFutureType = method.getGenericReturnType();
            if (!(returnFutureType instanceof ParameterizedType)) {
                throw new VException("Couldn't get return parameter type for method: " + method.getName());
            }
            if (((ParameterizedType)returnFutureType).getRawType() != ListenableFuture.class) {
                throw new VException("Server wrapper method must return a ListenableFuture: " + method.getName());
            }
            Type[] returnArgTypes = ((ParameterizedType)returnFutureType).getActualTypeArguments();
            if (returnArgTypes.length != 1) {
                throw new VException("Multiple return parameters for method: " + method.getName());
            }
            this.returnType = returnArgTypes[0];
            if (this.returnType == Void.class) {
                this.resultTypes = new Type[0];
            } else if (this.returnType instanceof Class && ((Class)this.returnType).getAnnotation(MultiReturn.class) != null) {
                Field[] fields = ((Class)this.returnType).getFields();
                this.resultTypes = new Type[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    this.resultTypes[i] = fields[i].getGenericType();
                }
            } else {
                this.resultTypes = new Type[]{this.returnType};
            }
        }

        public java.lang.reflect.Method getReflectMethod() {
            return this.method;
        }

        public VdlValue[] getTags() {
            return Arrays.copyOf(this.tags, this.tags.length);
        }

        public Type[] getArgumentTypes() {
            return Arrays.copyOf(this.argTypes, this.argTypes.length);
        }

        public Type[] getResultTypes() {
            return Arrays.copyOf(this.resultTypes, this.resultTypes.length);
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public Object invoke(Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.method.invoke(this.wrappedServer, args);
        }
    }
}

