/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.rpc;

import io.v.v23.rpc.NetworkAddress;
import io.v.v23.rpc.ServerState;
import io.v.v23.verror.VException;
import java.util.Arrays;
import org.joda.time.DateTime;

public class NetworkChange {
    private final DateTime time;
    private final ServerState state;
    private final NetworkAddress[] addedAddrs;
    private final NetworkAddress[] removedAddrs;
    private final String[] changedEndpoints;
    private final VException error;

    public NetworkChange(DateTime time, ServerState state, NetworkAddress[] addedAddrs, NetworkAddress[] removedAddrs, String[] changedEndpoints, VException error) {
        this.time = time;
        this.state = state;
        this.addedAddrs = Arrays.copyOf(addedAddrs, addedAddrs.length);
        this.removedAddrs = Arrays.copyOf(removedAddrs, removedAddrs.length);
        this.changedEndpoints = Arrays.copyOf(changedEndpoints, changedEndpoints.length);
        this.error = error;
    }

    public DateTime getTime() {
        return this.time;
    }

    public ServerState getState() {
        return this.state;
    }

    public NetworkAddress[] getAddedAddresses() {
        return Arrays.copyOf(this.addedAddrs, this.addedAddrs.length);
    }

    public NetworkAddress[] getRemovedAddresses() {
        return Arrays.copyOf(this.removedAddrs, this.removedAddrs.length);
    }

    public String[] getChangedEndpoints() {
        return Arrays.copyOf(this.changedEndpoints, this.changedEndpoints.length);
    }

    public VException getError() {
        return this.error;
    }

    public String toString() {
        return String.format("{Time: %s, State: %s, Added addrs: %s, Removed addrs: %s, Changed EPs: %s, Error: %s}", new Object[]{this.time, this.state, Arrays.toString(this.addedAddrs), Arrays.toString(this.removedAddrs), Arrays.toString(this.changedEndpoints), this.error});
    }
}

