/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.rpc;

import io.v.v23.rpc.AddressChooser;
import io.v.v23.rpc.NetworkAddress;
import io.v.v23.verror.VException;
import java.util.Arrays;

public class ListenSpec {
    private final Address[] addrs;
    private final String proxy;
    private final AddressChooser chooser;

    public ListenSpec(Address[] addrs, String proxy, AddressChooser chooser) {
        this.addrs = addrs == null ? new Address[]{} : Arrays.copyOf(addrs, addrs.length);
        this.proxy = proxy == null ? "" : proxy;
        this.chooser = chooser != null ? chooser : new AddressChooser(){

            @Override
            public NetworkAddress[] choose(String protocol, NetworkAddress[] candidates) throws VException {
                return candidates;
            }
        };
    }

    public ListenSpec(Address addr, String proxy, AddressChooser chooser) {
        this(new Address[]{addr}, proxy, chooser);
    }

    public ListenSpec(String protocol, String address) {
        this(new Address[]{new Address(protocol, address)}, "", null);
    }

    public ListenSpec withAddressChooser(AddressChooser newChooser) {
        return new ListenSpec(this.getAddresses(), this.proxy, newChooser);
    }

    public ListenSpec withProxy(String newProxy) {
        return new ListenSpec(this.getAddresses(), newProxy, this.chooser);
    }

    public ListenSpec withAddress(Address address) {
        return new ListenSpec(new Address[]{address}, this.proxy, this.chooser);
    }

    public Address[] getAddresses() {
        return Arrays.copyOf(this.addrs, this.addrs.length);
    }

    public String getProxy() {
        return this.proxy;
    }

    public AddressChooser getChooser() {
        return this.chooser;
    }

    public String toString() {
        return Arrays.toString(this.addrs) + (this.proxy.isEmpty() ? "" : "proxy(" + this.proxy + ")");
    }

    public static class Address {
        private final String protocol;
        private final String address;

        public Address(String protocol, String address) {
            this.protocol = protocol;
            this.address = address;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getAddress() {
            return this.address;
        }

        public String toString() {
            return this.protocol + ":" + this.address;
        }
    }
}

