/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.options;

import io.v.v23.Options;
import javax.annotation.Nullable;
import org.joda.time.Duration;

public final class RpcServerOptions {
    private static final Duration DEFAULT_LAME_DUCK_TIMEOUT = Duration.standardSeconds((long)0L);
    private boolean servesMountTable;
    private Duration lameDuckTimeout = DEFAULT_LAME_DUCK_TIMEOUT;
    private boolean isLeaf = true;
    private Duration channelTimeout;

    private static Duration migrateLameDuckTimeout(Options opts) {
        if (!opts.has("io.v.v23.SERVER_LAME_DUCK_TIMEOUT")) {
            return DEFAULT_LAME_DUCK_TIMEOUT;
        }
        Object timeout = opts.get("io.v.v23.SERVER_LAME_DUCK_TIMEOUT");
        if (!(timeout instanceof Duration)) {
            throw new RuntimeException("SERVER_LAME_DUCK_TIMEOUT option if specified must contain an object of type org.joda.time.Duration");
        }
        return (Duration)timeout;
    }

    @Nullable
    public static RpcServerOptions migrateOptions(@Nullable Options legacy) {
        return legacy == null ? null : new RpcServerOptions().lameDuckTimeout(RpcServerOptions.migrateLameDuckTimeout(legacy));
    }

    public RpcServerOptions servesMountTable(boolean servesMountTable) {
        this.servesMountTable = servesMountTable;
        return this;
    }

    public RpcServerOptions lameDuckTimeout(Duration lameDuckTimeout) {
        this.lameDuckTimeout = lameDuckTimeout;
        return this;
    }

    public RpcServerOptions isLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
        return this;
    }

    public RpcServerOptions channelTimeout(Duration channelTimeout) {
        this.channelTimeout = channelTimeout;
        return this;
    }

    public boolean servesMountTable() {
        return this.servesMountTable;
    }

    public Duration lameDuckTimeout() {
        return this.lameDuckTimeout;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public Duration channelTimeout() {
        return this.channelTimeout;
    }
}

