/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.options;

import io.v.v23.Options;
import io.v.v23.naming.MountEntry;
import io.v.v23.security.Authorizer;
import io.v.v23.security.VSecurity;
import javax.annotation.Nullable;
import org.joda.time.Duration;

public final class RpcOptions {
    private Authorizer nameResolutionAuthorizer;
    private Authorizer serverAuthorizer;
    private MountEntry preresolved;
    private boolean noRetry;
    private Duration connectionTimeout;
    private Duration channelTimeout;

    private static Authorizer migrateNameResolutionAuthorizer(Options opts) {
        if (opts.has("io.v.v23.SKIP_SERVER_ENDPOINT_AUTHORIZATION") && opts.get("io.v.v23.SKIP_SERVER_ENDPOINT_AUTHORIZATION", Boolean.class).booleanValue()) {
            return VSecurity.newAllowEveryoneAuthorizer();
        }
        return !opts.has("io.v.v23.NAME_RESOLUTION_AUTHORIZER") ? null : opts.get("io.v.v23.NAME_RESOLUTION_AUTHORIZER", Authorizer.class);
    }

    private static Authorizer migrateServerAuthorizer(Options opts) {
        if (opts.has("io.v.v23.SKIP_SERVER_ENDPOINT_AUTHORIZATION") && opts.get("io.v.v23.SKIP_SERVER_ENDPOINT_AUTHORIZATION", Boolean.class).booleanValue()) {
            return VSecurity.newAllowEveryoneAuthorizer();
        }
        return !opts.has("io.v.v23.SERVER_AUTHORIZER") ? null : opts.get("io.v.v23.SERVER_AUTHORIZER", Authorizer.class);
    }

    @Nullable
    public static RpcOptions migrateOptions(@Nullable Options legacy) {
        return legacy == null ? null : new RpcOptions().nameResolutionAuthorizer(RpcOptions.migrateNameResolutionAuthorizer(legacy)).serverAuthorizer(RpcOptions.migrateServerAuthorizer(legacy));
    }

    public RpcOptions nameResolutionAuthorizer(Authorizer nameResolutionAuthorizer) {
        this.nameResolutionAuthorizer = nameResolutionAuthorizer;
        return this;
    }

    public RpcOptions serverAuthorizer(Authorizer serverAuthorizer) {
        this.serverAuthorizer = serverAuthorizer;
        return this;
    }

    public RpcOptions preresolved(MountEntry preresolved) {
        this.preresolved = preresolved;
        return this;
    }

    public RpcOptions noRetry(boolean noRetry) {
        this.noRetry = noRetry;
        return this;
    }

    public RpcOptions connectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public RpcOptions channelTimeout(Duration channelTimeout) {
        this.channelTimeout = channelTimeout;
        return this;
    }

    public Authorizer nameResolutionAuthorizer() {
        return this.nameResolutionAuthorizer;
    }

    public Authorizer serverAuthorizer() {
        return this.serverAuthorizer;
    }

    public MountEntry preresolved() {
        return this.preresolved;
    }

    public boolean noRetry() {
        return this.noRetry;
    }

    public Duration connectionTimeout() {
        return this.connectionTimeout;
    }

    public Duration channelTimeout() {
        return this.channelTimeout;
    }

    public RpcOptions skipServerEndpointAuthorization() {
        this.nameResolutionAuthorizer = this.serverAuthorizer = VSecurity.newAllowEveryoneAuthorizer();
        return this;
    }
}

