/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.i18n;

import io.v.v23.i18n.Language;
import io.v.v23.verror.VException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Catalog {
    private final Map<String, Map<String, String>> formats = new HashMap<String, Map<String, String>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    private static native String nativeFormatParams(String var0, String[] var1) throws VException;

    public static String formatParams(String format, Object ... params) {
        try {
            return Catalog.nativeFormatParams(format, Catalog.convertParamsToStr(params));
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't format params.", e);
        }
    }

    private static String[] convertParamsToStr(Object ... params) {
        String[] ret = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            ret[i] = "" + params[i];
        }
        return ret;
    }

    public String lookup(String language, String msgID) {
        this.lock.readLock().lock();
        String fmt = this.lookupUnlocked(language, msgID);
        if (fmt.isEmpty()) {
            fmt = this.lookupUnlocked(Language.baseLanguage(language), msgID);
        }
        this.lock.readLock().unlock();
        return fmt;
    }

    private String lookupUnlocked(String language, String msgID) {
        Map<String, String> msgFmtMap = this.formats.get(language);
        if (msgFmtMap == null) {
            return "";
        }
        String fmt = msgFmtMap.get(msgID);
        return fmt == null ? "" : fmt;
    }

    public String format(String language, String msgID, Object ... params) {
        String formatStr = this.lookup(language, msgID);
        if (formatStr.isEmpty()) {
            formatStr = msgID;
            if (params.length > 0) {
                formatStr = formatStr + "{:_}";
            }
        }
        return Catalog.formatParams(formatStr, params);
    }

    public String set(String language, String msgID, String newFormat) {
        this.lock.writeLock().lock();
        String oldFormat = this.setUnlocked(language, msgID, newFormat);
        this.lock.writeLock().unlock();
        return oldFormat;
    }

    public String setWithBase(String language, String msgID, String newFormat) {
        this.lock.writeLock().lock();
        String oldFormat = this.setUnlocked(language, msgID, newFormat);
        String baseLang = Language.baseLanguage(language);
        String baseFmt = this.lookupUnlocked(baseLang, msgID);
        if (baseFmt.isEmpty() && !newFormat.isEmpty() && !baseLang.equals(language)) {
            this.setUnlocked(baseLang, msgID, newFormat);
        }
        this.lock.writeLock().unlock();
        return oldFormat;
    }

    private String setUnlocked(String language, String msgID, String newFormat) {
        Map<String, String> msgFmtMap = this.formats.get(language);
        if (msgFmtMap == null) {
            msgFmtMap = new HashMap<String, String>();
            this.formats.put(language, msgFmtMap);
        }
        String oldFormat = msgFmtMap.get(msgID);
        if (newFormat != null && !newFormat.isEmpty()) {
            msgFmtMap.put(msgID, newFormat);
        } else {
            msgFmtMap.remove(msgID);
            if (msgFmtMap.isEmpty()) {
                this.formats.remove(language);
            }
        }
        return oldFormat == null ? "" : oldFormat;
    }

    public void merge(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = null;
        Pattern pattern = Pattern.compile("^\\s*([^\\s\"]+)\\s+([^\\s\"]+)\\s+\"((?:[^\"]|\\\")*)\".*$");
        while ((line = reader.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches() || matcher.groupCount() != 3 || matcher.group(1).startsWith("#")) continue;
            String language = matcher.group(1);
            String msgID = matcher.group(2);
            String format = matcher.group(3);
            this.set(language, msgID, format);
        }
        reader.close();
    }

    public void output(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        this.lock.readLock().lock();
        for (Map.Entry<String, Map<String, String>> entry : this.formats.entrySet()) {
            String language = entry.getKey();
            for (Map.Entry<String, String> idFmt : entry.getValue().entrySet()) {
                String msgID = idFmt.getKey();
                String format = idFmt.getValue();
                writer.write(String.format("%s %s \"%s\"\n", language, msgID, format));
            }
        }
        this.lock.readLock().unlock();
        writer.close();
    }
}

