/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.context;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.impl.google.ListenableFutureCallback;
import io.v.v23.rpc.Callback;
import io.v.v23.verror.VException;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class VContext {
    private long nativeRef;
    private long nativeCancelRef;

    private static native VContext nativeCreate() throws VException;

    public static VContext create() {
        try {
            return VContext.nativeCreate();
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't create new context", e);
        }
    }

    private native void nativeCancel(long var1);

    private native boolean nativeIsCanceled(long var1);

    private native DateTime nativeDeadline(long var1) throws VException;

    private native void nativeOnDone(long var1, Callback<DoneReason> var3);

    private native Object nativeValue(long var1, String var3) throws VException;

    private native VContext nativeWithCancel(long var1) throws VException;

    private native VContext nativeWithDeadline(long var1, DateTime var3) throws VException;

    private native VContext nativeWithTimeout(long var1, Duration var3) throws VException;

    private native VContext nativeWithValue(long var1, long var3, String var5, Object var6) throws VException;

    private native void nativeFinalize(long var1, long var3);

    protected VContext(long nativeRef, long nativeCancelRef) {
        this.nativeRef = nativeRef;
        this.nativeCancelRef = nativeCancelRef;
    }

    public boolean isCancelable() {
        return this.nativeCancelRef != 0L;
    }

    public boolean isCanceled() {
        return this.nativeIsCanceled(this.nativeRef);
    }

    public void cancel() {
        Preconditions.checkState((boolean)this.isCancelable(), (Object)"Context isn't cancelable.");
        this.nativeCancel(this.nativeCancelRef);
    }

    public ListenableFuture<DoneReason> onDone() {
        ListenableFutureCallback<DoneReason> callback = new ListenableFutureCallback<DoneReason>();
        this.nativeOnDone(this.nativeRef, callback);
        return callback.getFutureOnExecutor(this);
    }

    public DateTime deadline() {
        try {
            return this.nativeDeadline(this.nativeRef);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get deadline", e);
        }
    }

    public Object value(Object key) {
        try {
            return this.nativeValue(this.nativeRef, VContext.keySignature(key));
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get value: ", e);
        }
    }

    public VContext withCancel() {
        try {
            return this.nativeWithCancel(this.nativeRef);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't create cancelable context", e);
        }
    }

    public VContext withDeadline(DateTime deadline) {
        try {
            return this.nativeWithDeadline(this.nativeRef, deadline);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't create context with deadline", e);
        }
    }

    public VContext withTimeout(Duration timeout) {
        try {
            return this.nativeWithTimeout(this.nativeRef, timeout);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't create context with timeout", e);
        }
    }

    public VContext withValue(Object key, Object value) {
        try {
            return this.nativeWithValue(this.nativeRef, this.nativeCancelRef, VContext.keySignature(key), value);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't create context with data:", e);
        }
    }

    private static String keySignature(Object key) {
        if (key == null) {
            return "";
        }
        return key.getClass().getName() + ":" + key.hashCode();
    }

    private long nativeRef() {
        return this.nativeRef;
    }

    private long nativeCancelRef() {
        return this.nativeCancelRef;
    }

    protected void finalize() {
        this.nativeFinalize(this.nativeRef, this.nativeCancelRef);
    }

    public static enum DoneReason {
        CANCELED,
        DEADLINE_EXCEEDED;

    }
}

