/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.V;
import io.v.v23.context.VContext;
import io.v.v23.verror.CanceledException;
import io.v.v23.verror.VException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class VFutures {
    public static <T> T sync(Future<T> future) throws VException {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof VException) {
                throw (VException)e.getCause();
            }
            if (e.getCause() instanceof CancellationException) {
                throw new CanceledException(null);
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException("Vanadium futures may only raise a VException or a RuntimeException.", e.getCause());
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Vanadium future may not raise an InterruptedException.", e);
        }
        catch (CancellationException e) {
            throw new CanceledException(null);
        }
    }

    public static <T> T sync(Future<T> future, long timeout, TimeUnit unit) throws VException, TimeoutException {
        try {
            return future.get(timeout, unit);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof VException) {
                throw (VException)e.getCause();
            }
            if (e.getCause() instanceof CancellationException) {
                throw new CanceledException(null);
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException("Vanadium futures may only raise a VException or a RuntimeException.", e.getCause());
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Vanadium future may not raise an InterruptedException.", e);
        }
        catch (CancellationException e) {
            throw new CanceledException(null);
        }
    }

    public static <T> ListenableFuture<T> onExecutor(VContext context, ListenableFuture<T> future) {
        Executor executor = V.getExecutor(context);
        if (executor == null) {
            return future;
        }
        return Futures.transform(future, (AsyncFunction)new AsyncFunction<T, T>(){

            public ListenableFuture<T> apply(T input) throws Exception {
                return Futures.immediateFuture(input);
            }
        }, (Executor)executor);
    }

    public static <T> ListenableFuture<T> withUserLandChecks(final VContext context, ListenableFuture<T> future) {
        Executor executor = V.getExecutor(context);
        if (executor == null) {
            throw new RuntimeException("NULL executor in context: did you derive this context from the context returned by V.init()?");
        }
        return Futures.transform(future, (AsyncFunction)new AsyncFunction<T, T>(){

            public ListenableFuture<T> apply(T input) throws Exception {
                if (context.isCanceled()) {
                    return Futures.immediateCancelledFuture();
                }
                return Futures.immediateFuture(input);
            }
        }, (Executor)executor);
    }
}

