/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23;

import com.google.common.io.ByteStreams;
import com.google.common.io.Resources;
import io.v.impl.google.rt.VRuntimeImpl;
import io.v.v23.Options;
import io.v.v23.VLoaderException;
import io.v.v23.VRuntime;
import io.v.v23.context.VContext;
import io.v.v23.discovery.Discovery;
import io.v.v23.namespace.Namespace;
import io.v.v23.options.RpcServerOptions;
import io.v.v23.rpc.Client;
import io.v.v23.rpc.Dispatcher;
import io.v.v23.rpc.ListenSpec;
import io.v.v23.rpc.Server;
import io.v.v23.security.Authorizer;
import io.v.v23.security.CaveatRegistry;
import io.v.v23.security.ConstCaveatValidator;
import io.v.v23.security.Constants;
import io.v.v23.security.ExpiryCaveatValidator;
import io.v.v23.security.MethodCaveatValidator;
import io.v.v23.security.PublicKeyThirdPartyCaveatValidator;
import io.v.v23.security.VPrincipal;
import io.v.v23.verror.VException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class V {
    private static volatile VRuntime runtime;
    private static volatile VContext globalContext;

    private static native void nativeInitGlobalShared() throws VException;

    private static native void nativeInitGlobalJava(Options var0) throws VException;

    private static boolean isDarwin() {
        return System.getProperty("os.name").toLowerCase().contains("os x");
    }

    private static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }

    protected static VContext initGlobalShared(Options opts) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            System.loadLibrary("v23");
        }
        catch (UnsatisfiedLinkError ule) {
            errors.add(new RuntimeException("loadLibrary attempt failed", ule));
            try {
                URL resource = null;
                File file = null;
                if (V.isLinux()) {
                    resource = Resources.getResource((String)"libv23.so");
                    file = File.createTempFile("libv23-", ".so");
                } else if (V.isDarwin()) {
                    resource = Resources.getResource((String)"libv23.dylib");
                    file = File.createTempFile("libv23-", ".dylib");
                } else {
                    String os = System.getProperty("os.name");
                    errors.add(new RuntimeException("unsupported OS: " + os));
                    throw new RuntimeException("Unsupported OS: " + os, new VLoaderException(errors));
                }
                file.deleteOnExit();
                ByteStreams.copy((InputStream)resource.openStream(), (OutputStream)new FileOutputStream(file));
                System.load(file.getAbsolutePath());
            }
            catch (IllegalArgumentException iae) {
                errors.add(new RuntimeException("couldn't locate libv23.so on the classpath", iae));
                throw new RuntimeException("Could not load v23 native library", new VLoaderException(errors));
            }
            catch (IOException e) {
                errors.add(new RuntimeException("error while reading libv23.so from the classpath", e));
                throw new RuntimeException("Could not load v23 native library", new VLoaderException(errors));
            }
            catch (UnsatisfiedLinkError e) {
                errors.add(new RuntimeException("error while reading libv23.so from the classpath", e));
                throw new RuntimeException("Could not load v23 native library", new VLoaderException(errors));
            }
        }
        try {
            V.nativeInitGlobalShared();
        }
        catch (VException e) {
            throw new RuntimeException("Could not initialize v23 native library", e);
        }
        try {
            CaveatRegistry.register(Constants.CONST_CAVEAT, ConstCaveatValidator.INSTANCE);
            CaveatRegistry.register(Constants.EXPIRY_CAVEAT, ExpiryCaveatValidator.INSTANCE);
            CaveatRegistry.register(Constants.METHOD_CAVEAT, MethodCaveatValidator.INSTANCE);
            CaveatRegistry.register(Constants.PUBLIC_KEY_THIRD_PARTY_CAVEAT, PublicKeyThirdPartyCaveatValidator.INSTANCE);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't register caveat validators", e);
        }
        if (opts.get("io.v.v23.RUNTIME") != null) {
            runtime = opts.get("io.v.v23.RUNTIME", VRuntime.class);
        } else {
            try {
                runtime = VRuntimeImpl.create(opts);
            }
            catch (VException e) {
                throw new RuntimeException("Couldn't initialize Google Vanadium Runtime", e);
            }
        }
        VContext ctx = runtime.getContext();
        if (!ctx.isCancelable()) {
            throw new RuntimeException("Context returned by the runtime must be cancelable");
        }
        return ctx;
    }

    private static VContext initGlobalJava(VContext ctx, Options opts) {
        try {
            V.nativeInitGlobalJava(opts);
            ctx = V.withExecutor(ctx, Executors.newCachedThreadPool());
            return ctx;
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't initialize Java", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VContext initGlobal(Options opts) {
        if (globalContext != null) {
            return globalContext;
        }
        Class<V> clazz = V.class;
        synchronized (V.class) {
            if (globalContext != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return globalContext;
            }
            if (opts == null) {
                opts = new Options();
            }
            VContext ctx = V.initGlobalShared(opts);
            ctx = V.initGlobalJava(ctx, opts);
            globalContext = ctx = VException.contextWithComponentName(ctx, System.getProperty("program.name", ""));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ctx;
        }
    }

    private static synchronized VContext init(Options opts) {
        VContext ctx = V.initGlobal(opts);
        return ctx.withCancel();
    }

    public static VContext init() {
        return V.init(null);
    }

    public static VContext withNewClient(VContext ctx) throws VException {
        return V.withNewClient(ctx, null);
    }

    public static VContext withNewClient(VContext ctx, Options opts) throws VException {
        if (opts == null) {
            opts = new Options();
        }
        return V.getRuntime(ctx).withNewClient(ctx, opts);
    }

    public static Client getClient(VContext ctx) {
        return V.getRuntime(ctx).getClient(ctx);
    }

    public static VContext withNewServer(VContext ctx, String name, Object object, Authorizer authorizer) throws VException {
        return V.withNewServer(ctx, name, object, authorizer, (RpcServerOptions)null);
    }

    public static VContext withNewServer(VContext ctx, String name, Object object, Authorizer authorizer, RpcServerOptions opts) throws VException {
        if (opts == null) {
            opts = new RpcServerOptions();
        }
        return V.getRuntime(ctx).withNewServer(ctx, name, object, authorizer, opts);
    }

    public static VContext withNewServer(VContext ctx, String name, Object object, Authorizer authorizer, Options opts) throws VException {
        return V.withNewServer(ctx, name, object, authorizer, RpcServerOptions.migrateOptions(opts));
    }

    public static VContext withNewServer(VContext ctx, String name, Dispatcher dispatcher) throws VException {
        return V.withNewServer(ctx, name, dispatcher, (RpcServerOptions)null);
    }

    public static VContext withNewServer(VContext ctx, String name, Dispatcher dispatcher, RpcServerOptions opts) throws VException {
        if (opts == null) {
            opts = new RpcServerOptions();
        }
        return V.getRuntime(ctx).withNewServer(ctx, name, dispatcher, opts);
    }

    public static VContext withNewServer(VContext ctx, String name, Dispatcher dispatcher, Options opts) throws VException {
        return V.withNewServer(ctx, name, dispatcher, RpcServerOptions.migrateOptions(opts));
    }

    public static Server getServer(VContext ctx) {
        return V.getRuntime(ctx).getServer(ctx);
    }

    public static VContext withPrincipal(VContext ctx, VPrincipal principal) throws VException {
        return V.getRuntime(ctx).withPrincipal(ctx, principal);
    }

    public static VPrincipal getPrincipal(VContext ctx) {
        return V.getRuntime(ctx).getPrincipal(ctx);
    }

    public static VContext withNewNamespace(VContext ctx, String ... roots) throws VException {
        return V.getRuntime(ctx).withNewNamespace(ctx, roots);
    }

    public static Namespace getNamespace(VContext ctx) {
        return V.getRuntime(ctx).getNamespace(ctx);
    }

    public static VContext withListenSpec(VContext ctx, ListenSpec spec) throws VException {
        return V.getRuntime(ctx).withListenSpec(ctx, spec);
    }

    public static ListenSpec getListenSpec(VContext ctx) {
        return V.getRuntime(ctx).getListenSpec(ctx);
    }

    public static Discovery newDiscovery(VContext ctx) throws VException {
        return V.getRuntime(ctx).newDiscovery(ctx);
    }

    public static VContext withExecutor(VContext ctx, Executor executor) {
        return ctx.withValue(new ExecutorKey(), executor);
    }

    public static Executor getExecutor(VContext ctx) {
        return (Executor)ctx.value(new ExecutorKey());
    }

    private static VRuntime getRuntime(VContext ctx) {
        if (runtime == null) {
            throw new RuntimeException("Vanadium runtime is null: did you call V.init()?");
        }
        return runtime;
    }

    protected V() {
    }

    private static class ExecutorKey {
        private ExecutorKey() {
        }

        public int hashCode() {
            return 0;
        }
    }
}

