/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.v.v23.InputChannel;
import io.v.v23.InputChannelCallback;
import io.v.v23.VFutures;
import io.v.v23.VIterable;
import io.v.v23.context.VContext;
import io.v.v23.verror.EndOfFileException;
import io.v.v23.verror.VException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.CheckReturnValue;

public class InputChannels {
    public static <F, T> InputChannel<T> transform(VContext ctx, InputChannel<F> fromChannel, TransformFunction<? super F, ? extends T> function) {
        return new TransformedChannel(ctx, fromChannel, function);
    }

    @CheckReturnValue
    public static <T> ListenableFuture<List<T>> asList(InputChannel<T> channel) {
        return InputChannels.asList(channel, MoreExecutors.directExecutor());
    }

    @CheckReturnValue
    public static <T> ListenableFuture<List<T>> asList(InputChannel<T> channel, Executor executor) {
        SettableFuture future = SettableFuture.create();
        Futures.addCallback(channel.recv(), InputChannels.newCallbackForList(channel, new ArrayList(), future, executor), (Executor)executor);
        return future;
    }

    private static <T> FutureCallback<T> newCallbackForList(final InputChannel<T> channel, final List<T> list, final SettableFuture<List<T>> future, final Executor executor) {
        return new FutureCallback<T>(){

            public void onSuccess(T result) {
                list.add(result);
                Futures.addCallback(channel.recv(), (FutureCallback)InputChannels.newCallbackForList(channel, list, future, executor), (Executor)executor);
            }

            public void onFailure(Throwable t) {
                if (t instanceof EndOfFileException) {
                    future.set((Object)list);
                } else {
                    future.setException(t);
                }
            }
        };
    }

    @CheckReturnValue
    public static <T> ListenableFuture<Void> asDone(InputChannel<T> channel) {
        return InputChannels.asDone(channel, MoreExecutors.directExecutor());
    }

    @CheckReturnValue
    public static <T> ListenableFuture<Void> asDone(InputChannel<T> channel, Executor executor) {
        SettableFuture future = SettableFuture.create();
        Futures.addCallback(channel.recv(), InputChannels.newCallbackForDone(channel, (SettableFuture<Void>)future, executor), (Executor)executor);
        return future;
    }

    private static <T> FutureCallback<T> newCallbackForDone(final InputChannel<T> channel, final SettableFuture<Void> future, final Executor executor) {
        return new FutureCallback<T>(){

            public void onSuccess(T result) {
                Futures.addCallback(channel.recv(), (FutureCallback)InputChannels.newCallbackForDone(channel, (SettableFuture<Void>)future, executor), (Executor)executor);
            }

            public void onFailure(Throwable t) {
                if (t instanceof EndOfFileException) {
                    future.set(null);
                } else {
                    future.setException(t);
                }
            }
        };
    }

    public static <T> VIterable<T> asIterable(InputChannel<? extends T> channel) {
        return new ChannelIterable(channel);
    }

    @CheckReturnValue
    public static <T> ListenableFuture<Void> withCallback(InputChannel<T> channel, InputChannelCallback<? super T> callback) {
        return InputChannels.withCallback(channel, callback, MoreExecutors.directExecutor());
    }

    @CheckReturnValue
    public static <T> ListenableFuture<Void> withCallback(InputChannel<T> channel, InputChannelCallback<? super T> callback, Executor executor) {
        SettableFuture future = SettableFuture.create();
        Futures.addCallback(channel.recv(), InputChannels.newCallbackForCallback(channel, (SettableFuture<Void>)future, callback, executor), (Executor)executor);
        return future;
    }

    private static <T> FutureCallback<T> newCallbackForCallback(final InputChannel<T> channel, final SettableFuture<Void> future, final InputChannelCallback<? super T> callback, final Executor executor) {
        return new FutureCallback<T>(){

            public void onSuccess(T result) {
                ListenableFuture done = callback.onNext(result);
                if (done == null) {
                    done = Futures.immediateFuture(null);
                }
                Futures.addCallback((ListenableFuture)Futures.transform((ListenableFuture)done, (AsyncFunction)new AsyncFunction<Void, T>(){

                    public ListenableFuture<T> apply(Void input) throws Exception {
                        return channel.recv();
                    }
                }), (FutureCallback)InputChannels.newCallbackForCallback(channel, (SettableFuture<Void>)future, callback, executor), (Executor)executor);
            }

            public void onFailure(Throwable t) {
                if (t instanceof EndOfFileException) {
                    future.set(null);
                    return;
                }
                future.setException(t);
            }
        };
    }

    private static class ChannelIterable<T>
    implements VIterable<T> {
        private final InputChannel<? extends T> fromChannel;
        private boolean isCreated;
        private volatile VException error;

        private ChannelIterable(InputChannel<? extends T> fromChannel) {
            this.fromChannel = fromChannel;
        }

        @Override
        public synchronized Iterator<T> iterator() {
            Preconditions.checkState((!this.isCreated ? 1 : 0) != 0, (Object)"Can only create one iterator.");
            this.isCreated = true;
            return new AbstractIterator<T>(){

                protected T computeNext() {
                    try {
                        Object result = VFutures.sync(ChannelIterable.this.fromChannel.recv());
                        return result;
                    }
                    catch (EndOfFileException e) {
                        return this.endOfData();
                    }
                    catch (VException e) {
                        ChannelIterable.this.error = e;
                        return this.endOfData();
                    }
                }
            };
        }

        @Override
        public VException error() {
            return this.error != null ? this.error : null;
        }
    }

    private static class TransformedChannel<F, T>
    implements InputChannel<T> {
        private final VContext ctx;
        private final InputChannel<F> fromChannel;
        private final TransformFunction<? super F, ? extends T> function;

        private TransformedChannel(VContext ctx, InputChannel<F> fromChannel, TransformFunction<? super F, ? extends T> function) {
            this.ctx = ctx;
            this.fromChannel = fromChannel;
            this.function = function;
        }

        @Override
        public ListenableFuture<T> recv() {
            return VFutures.withUserLandChecks(this.ctx, Futures.transform(this.fromChannel.recv(), (AsyncFunction)new AsyncFunction<F, T>(){

                public ListenableFuture<T> apply(F input) throws Exception {
                    Object output = TransformedChannel.this.function.apply(input);
                    if (output == null) {
                        return TransformedChannel.this.recv();
                    }
                    return Futures.immediateFuture(output);
                }
            }));
        }
    }

    public static interface TransformFunction<F, T> {
        public T apply(F var1) throws VException;
    }
}

