/*
 * Decompiled with CFR 0.152.
 */
package io.v.impl.google.services.mounttable;

import io.v.v23.context.VContext;
import io.v.v23.security.access.Permissions;
import io.v.v23.verror.VException;
import java.util.Map;

public class MountTableServer {
    private static native VContext nativeWithNewServer(VContext var0, Params var1) throws VException;

    public static VContext withNewServer(VContext ctx, Params params) throws StartException {
        try {
            return MountTableServer.nativeWithNewServer(ctx, params);
        }
        catch (VException e) {
            throw new StartException(e.getMessage());
        }
    }

    public static class StartException
    extends Exception {
        public StartException(String msg) {
            super(msg);
        }
    }

    public static class Params {
        private Params parent = null;
        private String name;
        private String rootDir;
        private Map<String, Permissions> perms;
        private String statsPrefix;

        public Params() {
        }

        private Params(Params parent) {
            this.parent = parent;
        }

        public Params withName(String name) {
            Params ret = new Params(this);
            ret.name = name;
            return ret;
        }

        public Params withStorageRootDir(String rootDir) {
            Params ret = new Params(this);
            ret.rootDir = rootDir;
            return ret;
        }

        public Params withPermissions(Map<String, Permissions> perms) {
            Params ret = new Params(this);
            ret.perms = perms;
            return ret;
        }

        public Params withStatsPrefix(String statsPrefix) {
            Params ret = new Params(this);
            ret.statsPrefix = statsPrefix;
            return ret;
        }

        public String getName() {
            if (this.name != null) {
                return this.name;
            }
            if (this.parent != null) {
                return this.parent.getName();
            }
            return null;
        }

        public String getStorageRootDir() {
            if (this.rootDir != null) {
                return this.rootDir;
            }
            if (this.parent != null) {
                return this.parent.getStorageRootDir();
            }
            return null;
        }

        public Map<String, Permissions> getPermissions() {
            if (this.perms != null) {
                return this.perms;
            }
            if (this.parent != null) {
                return this.parent.getPermissions();
            }
            return null;
        }

        public String getStatsPrefix() {
            if (this.statsPrefix != null) {
                return this.statsPrefix;
            }
            if (this.parent != null) {
                return this.parent.getStatsPrefix();
            }
            return null;
        }
    }
}

