/*
 * Decompiled with CFR 0.152.
 */
package io.v.impl.google.services.groups;

import io.v.v23.context.VContext;
import io.v.v23.verror.VException;

public class GroupServer {
    private static native VContext nativeWithNewServer(VContext var0, Params var1) throws VException;

    public static VContext withNewServer(VContext ctx, Params params) throws StartException {
        try {
            return GroupServer.nativeWithNewServer(ctx, params);
        }
        catch (VException e) {
            throw new StartException(e.getMessage());
        }
    }

    public static class StartException
    extends Exception {
        public StartException(String msg) {
            super(msg);
        }
    }

    public static enum StorageEngine {
        LEVELDB("leveldb"),
        MEMSTORE("memstore");

        private final String value;

        private StorageEngine(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Params {
        private Params parent = null;
        private String name;
        private String storageRootDir;
        private StorageEngine storageEngine;

        public Params() {
        }

        private Params(Params parent) {
            this.parent = parent;
        }

        public Params withName(String name) {
            Params ret = new Params(this);
            ret.name = name;
            return ret;
        }

        public Params withStorageRootDir(String rootDir) {
            Params ret = new Params(this);
            ret.storageRootDir = rootDir;
            return ret;
        }

        public Params withStorageEngine(StorageEngine engine) {
            Params ret = new Params(this);
            ret.storageEngine = engine;
            return ret;
        }

        public String getName() {
            if (this.name != null) {
                return this.name;
            }
            if (this.parent != null) {
                return this.parent.getName();
            }
            return null;
        }

        public String getStorageRootDir() {
            if (this.storageRootDir != null) {
                return this.storageRootDir;
            }
            if (this.parent != null) {
                return this.parent.getStorageRootDir();
            }
            return null;
        }

        public StorageEngine getStorageEngine() {
            if (this.storageEngine != null) {
                return this.storageEngine;
            }
            if (this.parent != null) {
                return this.parent.getStorageEngine();
            }
            return null;
        }
    }
}

