/*
 * Decompiled with CFR 0.152.
 */
package io.v.impl.google.rt;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.impl.google.ListenableFutureCallback;
import io.v.v23.Options;
import io.v.v23.VRuntime;
import io.v.v23.context.VContext;
import io.v.v23.discovery.Discovery;
import io.v.v23.namespace.Namespace;
import io.v.v23.options.RpcServerOptions;
import io.v.v23.rpc.Callback;
import io.v.v23.rpc.Client;
import io.v.v23.rpc.Dispatcher;
import io.v.v23.rpc.Invoker;
import io.v.v23.rpc.ListenSpec;
import io.v.v23.rpc.ReflectInvoker;
import io.v.v23.rpc.Server;
import io.v.v23.rpc.ServiceObjectWithAuthorizer;
import io.v.v23.security.Authorizer;
import io.v.v23.security.VPrincipal;
import io.v.v23.verror.VException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class VRuntimeImpl
implements VRuntime {
    private final VContext ctx;

    private static native VContext nativeInit() throws VException;

    private static native ListenableFuture<Void> nativeShutdown(VContext var0, Callback<Void> var1);

    private static native VContext nativeWithNewClient(VContext var0, Options var1) throws VException;

    private static native Client nativeGetClient(VContext var0) throws VException;

    private static native VContext nativeWithNewServer(VContext var0, String var1, Dispatcher var2, RpcServerOptions var3) throws VException;

    private static native VContext nativeWithPrincipal(VContext var0, VPrincipal var1) throws VException;

    private static native VPrincipal nativeGetPrincipal(VContext var0) throws VException;

    private static native VContext nativeWithNewNamespace(VContext var0, String ... var1) throws VException;

    private static native Namespace nativeGetNamespace(VContext var0) throws VException;

    private static native VContext nativeWithListenSpec(VContext var0, ListenSpec var1) throws VException;

    private static native ListenSpec nativeGetListenSpec(VContext var0) throws VException;

    private static native Discovery nativeNewDiscovery(VContext var0) throws VException;

    private static VContext withServer(VContext ctx, Server server) {
        return ctx.withValue(new ServerKey(), server);
    }

    public static Executor getRuntimeExecutor(VContext ctx) {
        return (Executor)ctx.value(new RuntimeExecutorKey());
    }

    public static VRuntimeImpl create(Options opts) throws VException {
        VContext ctx = VRuntimeImpl.nativeInit();
        ctx = ctx.withValue(new RuntimeExecutorKey(), Executors.newCachedThreadPool());
        final VContext ctxC = ctx.withCancel();
        Futures.transform(ctxC.onDone(), (AsyncFunction)new AsyncFunction<VContext.DoneReason, Void>(){

            public ListenableFuture<Void> apply(VContext.DoneReason reason) {
                ListenableFutureCallback callback = new ListenableFutureCallback();
                VRuntimeImpl.nativeShutdown(ctxC, callback);
                return callback.getVanillaFuture();
            }
        });
        return new VRuntimeImpl(ctxC);
    }

    private VRuntimeImpl(VContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public VContext withNewClient(VContext ctx, Options opts) throws VException {
        return VRuntimeImpl.nativeWithNewClient(ctx, opts);
    }

    @Override
    public Client getClient(VContext ctx) {
        try {
            return VRuntimeImpl.nativeGetClient(ctx);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get client", e);
        }
    }

    @Override
    @Deprecated
    public VContext withNewServer(VContext ctx, String name, Dispatcher disp, Options opts) throws VException {
        return this.withNewServer(ctx, name, disp, RpcServerOptions.migrateOptions(opts));
    }

    @Override
    public VContext withNewServer(VContext ctx, String name, Dispatcher disp, RpcServerOptions opts) throws VException {
        return VRuntimeImpl.nativeWithNewServer(ctx, name, disp, opts);
    }

    @Override
    public VContext withNewServer(VContext ctx, String name, Object object, Authorizer authorizer, Options opts) throws VException {
        return this.withNewServer(ctx, name, object, authorizer, RpcServerOptions.migrateOptions(opts));
    }

    @Override
    public VContext withNewServer(VContext ctx, String name, Object object, Authorizer authorizer, RpcServerOptions opts) throws VException {
        if (object == null) {
            throw new VException("newServer called with a null object");
        }
        Invoker invoker = object instanceof Invoker ? (Invoker)object : new ReflectInvoker(object);
        return this.withNewServer(ctx, name, (Dispatcher)new DefaultDispatcher(invoker, authorizer), opts);
    }

    @Override
    public Server getServer(VContext ctx) {
        return (Server)ctx.value(new ServerKey());
    }

    @Override
    public VContext withPrincipal(VContext ctx, VPrincipal principal) throws VException {
        return VRuntimeImpl.nativeWithPrincipal(ctx, principal);
    }

    @Override
    public VPrincipal getPrincipal(VContext ctx) {
        try {
            return VRuntimeImpl.nativeGetPrincipal(ctx);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get principal", e);
        }
    }

    @Override
    public VContext withNewNamespace(VContext ctx, String ... roots) throws VException {
        return VRuntimeImpl.nativeWithNewNamespace(ctx, roots);
    }

    @Override
    public Namespace getNamespace(VContext ctx) {
        try {
            return VRuntimeImpl.nativeGetNamespace(ctx);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get namespace", e);
        }
    }

    @Override
    public VContext withListenSpec(VContext ctx, ListenSpec spec) throws VException {
        return VRuntimeImpl.nativeWithListenSpec(ctx, spec);
    }

    @Override
    public ListenSpec getListenSpec(VContext ctx) {
        try {
            return VRuntimeImpl.nativeGetListenSpec(ctx);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't get listen spec: ", e);
        }
    }

    @Override
    public Discovery newDiscovery(VContext ctx) throws VException {
        return VRuntimeImpl.nativeNewDiscovery(ctx);
    }

    @Override
    public VContext getContext() {
        return this.ctx;
    }

    private static class RuntimeExecutorKey {
        private RuntimeExecutorKey() {
        }

        public int hashCode() {
            return 0;
        }
    }

    private static class ServerKey {
        private ServerKey() {
        }

        public int hashCode() {
            return 0;
        }
    }

    private static class DefaultDispatcher
    implements Dispatcher {
        private final Invoker invoker;
        private final Authorizer auth;

        DefaultDispatcher(Invoker invoker, Authorizer auth) {
            this.invoker = invoker;
            this.auth = auth;
        }

        @Override
        public ServiceObjectWithAuthorizer lookup(String suffix) throws VException {
            return new ServiceObjectWithAuthorizer(this.invoker, this.auth);
        }
    }
}

