/*
 * Decompiled with CFR 0.152.
 */
package io.v.impl.google.rpc;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.impl.google.ListenableFutureCallback;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.rpc.Callback;
import io.v.v23.rpc.Stream;
import io.v.v23.verror.VException;
import io.v.v23.vom.VomUtil;
import java.lang.reflect.Type;

public class StreamImpl
implements Stream {
    private final VContext ctx;
    private final long nativeRef;

    private native void nativeSend(long var1, byte[] var3, Callback<Void> var4);

    private native void nativeRecv(long var1, Callback<byte[]> var3);

    private native void nativeFinalize(long var1);

    private StreamImpl(VContext ctx, long nativeRef) {
        this.ctx = ctx;
        this.nativeRef = nativeRef;
    }

    @Override
    public ListenableFuture<Void> send(Object item, Type type) {
        ListenableFutureCallback<Void> callback = new ListenableFutureCallback<Void>();
        try {
            byte[] vomItem = VomUtil.encode(item, type);
            this.nativeSend(this.nativeRef, vomItem, callback);
        }
        catch (VException e) {
            callback.onFailure(e);
        }
        return callback.getFuture(this.ctx);
    }

    @Override
    public ListenableFuture<Object> recv(final Type type) {
        ListenableFutureCallback<byte[]> callback = new ListenableFutureCallback<byte[]>();
        this.nativeRecv(this.nativeRef, callback);
        return VFutures.withUserLandChecks(this.ctx, Futures.transform(callback.getVanillaFuture(), (AsyncFunction)new AsyncFunction<byte[], Object>(){

            public ListenableFuture<Object> apply(byte[] result) throws Exception {
                return Futures.immediateFuture((Object)VomUtil.decode(result, type));
            }
        }));
    }

    protected void finalize() {
        this.nativeFinalize(this.nativeRef);
    }
}

