/*
 * Decompiled with CFR 0.152.
 */
package io.v.impl.google.rpc;

import com.google.common.util.concurrent.ListenableFuture;
import io.v.impl.google.ListenableFutureCallback;
import io.v.v23.Options;
import io.v.v23.context.VContext;
import io.v.v23.options.RpcOptions;
import io.v.v23.rpc.Callback;
import io.v.v23.rpc.Client;
import io.v.v23.rpc.ClientCall;
import io.v.v23.verror.VException;
import io.v.v23.vom.VomUtil;
import java.lang.reflect.Type;

public class ClientImpl
implements Client {
    private final long nativeRef;

    private native void nativeStartCall(long var1, VContext var3, String var4, String var5, byte[][] var6, RpcOptions var7, Callback<ClientCall> var8);

    private native void nativeClose(long var1);

    private native void nativeFinalize(long var1);

    private ClientImpl(long nativeRef) {
        this.nativeRef = nativeRef;
    }

    @Override
    public ListenableFuture<ClientCall> startCall(VContext ctx, String name, String method, Object[] args, Type[] argTypes) {
        return this.startCall(ctx, name, method, args, argTypes, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<ClientCall> startCall(VContext ctx, String name, String method, Object[] args, Type[] argTypes, Options opts) {
        if (opts == null) {
            opts = new Options();
        }
        return this.startCall(ctx, name, method, args, argTypes, RpcOptions.migrateOptions(opts));
    }

    @Override
    public ListenableFuture<ClientCall> startCall(VContext ctx, String name, String method, Object[] args, Type[] argTypes, RpcOptions opts) {
        ListenableFutureCallback<ClientCall> callback = new ListenableFutureCallback<ClientCall>();
        if (opts == null) {
            opts = new RpcOptions();
        }
        try {
            this.checkStartCallArgs(name, method, args, argTypes);
            this.nativeStartCall(this.nativeRef, ctx, name, this.getMethodName(method), this.getEncodedVomArgs(args, argTypes), opts, callback);
        }
        catch (VException e) {
            callback.onFailure(e);
        }
        return callback.getFuture(ctx);
    }

    private String getMethodName(String method) {
        return Character.toUpperCase(method.charAt(0)) + method.substring(1);
    }

    private void checkStartCallArgs(String name, String method, Object[] args, Type[] argTypes) throws VException {
        if ("".equals(method)) {
            throw new VException(String.format("Empty method name invoked on object %s", name));
        }
        if (args.length != argTypes.length) {
            throw new VException(String.format("Argument count (%d) doesn't match type count (%d) for method %s of object %s", args.length, argTypes.length, name, method));
        }
    }

    private byte[][] getEncodedVomArgs(Object[] args, Type[] argTypes) throws VException {
        byte[][] vomArgs = new byte[args.length][];
        for (int i = 0; i < args.length; ++i) {
            vomArgs[i] = VomUtil.encode(args[i], argTypes[i]);
        }
        return vomArgs;
    }

    @Override
    public void close() {
        this.nativeClose(this.nativeRef);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.nativeRef == ((ClientImpl)other).nativeRef;
    }

    public int hashCode() {
        return Long.valueOf(this.nativeRef).hashCode();
    }

    protected void finalize() {
        this.nativeFinalize(this.nativeRef);
    }
}

