/*
 * Decompiled with CFR 0.152.
 */
package io.v.impl.google.rpc;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.impl.google.ListenableFutureCallback;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.rpc.Callback;
import io.v.v23.rpc.ClientCall;
import io.v.v23.rpc.Stream;
import io.v.v23.verror.VException;
import io.v.v23.vom.VomUtil;
import java.lang.reflect.Type;

public class ClientCallImpl
implements ClientCall {
    private final VContext ctx;
    private final long nativeRef;
    private final Stream stream;

    private native void nativeCloseSend(long var1, Callback<Void> var3);

    private native void nativeFinish(long var1, int var3, Callback<byte[][]> var4);

    private native void nativeFinalize(long var1);

    private ClientCallImpl(VContext ctx, long nativeRef, Stream stream) {
        this.ctx = ctx;
        this.nativeRef = nativeRef;
        this.stream = stream;
    }

    @Override
    public ListenableFuture<Void> send(Object item, Type type) {
        return this.stream.send(item, type);
    }

    @Override
    public ListenableFuture<Object> recv(Type type) {
        return this.stream.recv(type);
    }

    @Override
    public ListenableFuture<Void> closeSend() {
        ListenableFutureCallback<Void> callback = new ListenableFutureCallback<Void>();
        this.nativeCloseSend(this.nativeRef, callback);
        return callback.getFuture(this.ctx);
    }

    @Override
    public ListenableFuture<Object[]> finish(final Type[] types) {
        ListenableFutureCallback<byte[][]> callback = new ListenableFutureCallback<byte[][]>();
        this.nativeFinish(this.nativeRef, types.length, callback);
        return VFutures.withUserLandChecks(this.ctx, Futures.transform(callback.getVanillaFuture(), (AsyncFunction)new AsyncFunction<byte[][], Object[]>(){

            public ListenableFuture<Object[]> apply(byte[][] vomResults) throws Exception {
                if (vomResults.length != types.length) {
                    throw new VException(String.format("Mismatch in number of results, want %s, have %s", types.length, vomResults.length));
                }
                Object[] ret = new Object[types.length];
                for (int i = 0; i < types.length; ++i) {
                    ret[i] = VomUtil.decode(vomResults[i], types[i]);
                }
                return Futures.immediateFuture((Object)ret);
            }
        }));
    }

    protected void finalize() {
        this.nativeFinalize(this.nativeRef);
    }
}

