/*
 * Decompiled with CFR 0.152.
 */
package io.v.impl.google.naming;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class NamingUtil {
    private static final String hexDigits = "0123456789ABCDEF";

    public static List<String> splitAddressName(String name) {
        if (!NamingUtil.isRooted(name = NamingUtil.clean(name))) {
            return ImmutableList.of((Object)"", (Object)name);
        }
        if ((name = name.substring(1, name.length())).isEmpty()) {
            return ImmutableList.of((Object)"", (Object)"");
        }
        if (name.startsWith("@")) {
            List<String> parts = NamingUtil.splitInTwo(name, "@@/");
            String addr = parts.get(0);
            String suffix = parts.get(1);
            if (!suffix.isEmpty()) {
                addr = addr + "@@";
            }
            return ImmutableList.of((Object)addr, (Object)suffix);
        }
        if (name.startsWith("(")) {
            String tmp = NamingUtil.splitInTwo(name, ")@").get(1);
            String suffix = NamingUtil.splitInTwo(tmp, "/").get(1);
            String addr = NamingUtil.trimSuffix(name, "/" + suffix);
            if (addr.endsWith("/" + suffix)) {
                addr = addr.substring(0, addr.length() - suffix.length() - 1);
            }
            return ImmutableList.of((Object)addr, (Object)suffix);
        }
        List<String> parts = NamingUtil.splitInTwo(name, "/");
        return ImmutableList.of((Object)parts.get(0), (Object)parts.get(1));
    }

    private static List<String> splitInTwo(String str, String separator) {
        Iterator iter = Splitter.on((String)separator).limit(2).split((CharSequence)str).iterator();
        return ImmutableList.of((Object)(iter.hasNext() ? (String)iter.next() : ""), (Object)(iter.hasNext() ? (String)iter.next() : ""));
    }

    public static String joinAddressName(String address, String name) {
        address = CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)address);
        if (address.isEmpty()) {
            return NamingUtil.clean(name);
        }
        if (name.isEmpty()) {
            return NamingUtil.clean("/" + address);
        }
        return NamingUtil.clean("/" + address + "/" + name);
    }

    public static String join(String ... names) {
        Iterator<String> iter = Arrays.asList(names).iterator();
        for (int i = 0; i < names.length && names[i].isEmpty(); ++i) {
            iter.next();
        }
        return NamingUtil.clean(Joiner.on((String)"/").join(iter));
    }

    public static List<String> split(String name) {
        return Splitter.on((String)"/").omitEmptyStrings().splitToList((CharSequence)name);
    }

    public static String trimSuffix(String name, String suffix) {
        if ((name = NamingUtil.clean(name)).equals(suffix = NamingUtil.clean(suffix))) {
            return "";
        }
        if (suffix.length() >= name.length()) {
            return name;
        }
        if (suffix.startsWith("/")) {
            return name;
        }
        if (name.endsWith(suffix)) {
            String prefix = name.substring(0, name.length() - suffix.length());
            if (prefix.endsWith("/")) {
                if (prefix.length() == 1) {
                    return name;
                }
                return prefix.substring(0, prefix.length() - 1);
            }
            return prefix;
        }
        return name;
    }

    public static String clean(String name) {
        CharMatcher slashMatcher = CharMatcher.is((char)'/');
        name = slashMatcher.collapseFrom((CharSequence)name, '/');
        if ("/".equals(name)) {
            return name;
        }
        return slashMatcher.trimTrailingFrom((CharSequence)name);
    }

    public static boolean isRooted(String name) {
        return name.startsWith("/");
    }

    public static String encodeAsNameElement(String name) {
        return NamingUtil.escape(name, new char[]{'/'});
    }

    public static String decodeFromNameElement(String name) {
        return NamingUtil.unescape(name);
    }

    public static String escape(String text, char[] special) {
        String specialStr = new String(special) + '%';
        boolean hasSpecial = false;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (specialStr.indexOf(ch) < 0) continue;
            hasSpecial = true;
            break;
        }
        if (!hasSpecial) {
            return text;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (specialStr.indexOf(ch) < 0) {
                buf.append(ch);
                continue;
            }
            byte[] bytes = new String(new char[]{ch}).getBytes();
            for (int j = 0; j < bytes.length; ++j) {
                buf.append('%');
                buf.append(hexDigits.charAt((bytes[j] & 0xF0) >> 4));
                buf.append(hexDigits.charAt(bytes[j] & 0xF));
            }
        }
        return buf.toString();
    }

    public static String unescape(String text) {
        if (text.indexOf(37) < 0) {
            return text;
        }
        StringBuffer result = new StringBuffer(text.length());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '%') {
                out.reset();
                do {
                    if (i + 2 >= text.length()) {
                        throw new IllegalArgumentException("Truncated or malformed encoded string");
                    }
                    int d1 = Character.digit(text.charAt(i + 1), 16);
                    int d2 = Character.digit(text.charAt(i + 2), 16);
                    if (d1 == -1 || d2 == -1) {
                        throw new IllegalArgumentException("Truncated or malformed encoded string");
                    }
                    out.write((byte)((d1 << 4) + d2));
                } while ((i += 3) < text.length() && text.charAt(i) == '%');
                result.append(out.toString());
                continue;
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    private NamingUtil() {
    }
}

