/*
 * Decompiled with CFR 0.152.
 */
package io.v.impl.google.naming;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import io.v.impl.google.naming.NamingUtil;
import io.v.v23.naming.Endpoint;
import io.v.v23.naming.RoutingId;
import io.v.v23.rpc.NetworkAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EndpointImpl
implements Endpoint {
    private static final Pattern hostPortPattern = Pattern.compile("^(?:\\((.*)\\)@)?([^@]+)$");
    private final String protocol;
    private final String address;
    private final List<String> routes;
    private final RoutingId routingId;
    private final List<String> blessingNames;
    private final boolean isMountTable;
    private final boolean isLeaf;

    public static Endpoint fromString(String s) {
        Matcher matcher = hostPortPattern.matcher(s);
        if (matcher.matches()) {
            ArrayList<String> blessings = new ArrayList<String>(1);
            HostAndPort hostPort = HostAndPort.fromString((String)matcher.group(matcher.groupCount()));
            if (matcher.group(1) != null) {
                blessings.add(matcher.group(1));
            }
            return new EndpointImpl("", hostPort.toString(), (List<String>)ImmutableList.of(), RoutingId.NULL_ROUTING_ID, blessings, true, false);
        }
        if (s.endsWith("@@")) {
            s = s.substring(0, s.length() - 2);
        }
        if (s.startsWith("@")) {
            s = s.substring(1, s.length());
        }
        List parts = Splitter.on((char)'@').splitToList((CharSequence)s);
        int version = Integer.parseInt((String)parts.get(0));
        switch (version) {
            case 6: {
                return EndpointImpl.fromV6String(parts);
            }
        }
        return null;
    }

    private static Endpoint fromV6String(List<String> parts) {
        boolean isLeaf;
        boolean isMountTable;
        if (parts.size() < 6) {
            throw new IllegalArgumentException("Invalid format for endpoint, expecting 6 '@'-separated components");
        }
        String protocol = parts.get(1);
        String address = EndpointImpl.unescapeAddress(parts.get(2));
        if (address.isEmpty()) {
            address = ":0";
        }
        List<String> routes = EndpointImpl.unescapeRoutes(Splitter.on((char)',').splitToList((CharSequence)parts.get(3)));
        RoutingId routingId = RoutingId.fromString(parts.get(4));
        String mountTableFlag = parts.get(5);
        if ("".equals(mountTableFlag)) {
            isMountTable = true;
            isLeaf = false;
        } else if ("l".equals(mountTableFlag)) {
            isMountTable = false;
            isLeaf = true;
        } else if ("m".equals(mountTableFlag)) {
            isMountTable = true;
            isLeaf = false;
        } else if ("s".equals(mountTableFlag)) {
            isMountTable = false;
            isLeaf = false;
        } else {
            throw new IllegalArgumentException("Invalid mounttable flag " + mountTableFlag + ", should be one of 'l', 'm' or 's'");
        }
        Object blessings = "".equals(parts.get(6)) ? ImmutableList.of() : Splitter.on((char)',').splitToList((CharSequence)Joiner.on((String)"@").join(parts.subList(6, parts.size())));
        return new EndpointImpl(protocol, address, routes, routingId, (List<String>)blessings, isMountTable, isLeaf);
    }

    EndpointImpl(String protocol, String address, List<String> routes, RoutingId routingId, List<String> blessingNames, boolean isMountTable, boolean isLeaf) {
        this.protocol = protocol;
        this.address = address;
        this.routes = ImmutableList.copyOf(routes);
        this.routingId = routingId;
        this.blessingNames = ImmutableList.copyOf(blessingNames);
        this.isMountTable = isMountTable;
        this.isLeaf = isLeaf;
    }

    @Override
    public String name() {
        return NamingUtil.joinAddressName(this.toString(), "");
    }

    @Override
    public RoutingId routingId() {
        return this.routingId;
    }

    @Override
    public List<String> routes() {
        return this.routes;
    }

    @Override
    public NetworkAddress address() {
        return new NetworkAddress(this.protocol, this.address);
    }

    @Override
    public boolean servesMountTable() {
        return this.isMountTable;
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public List<String> blessingNames() {
        return this.blessingNames;
    }

    private List<String> escapedRoutes() {
        int len = this.routes.size();
        ArrayList<String> escaped = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            escaped.add(EndpointImpl.escapeString(this.routes.get(i)));
        }
        return escaped;
    }

    private static List<String> unescapeRoutes(List<String> s) {
        int len = s.size();
        ArrayList<String> unescaped = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            unescaped.add(EndpointImpl.unescapeString(s.get(i)));
        }
        return unescaped;
    }

    private String escapedAddress() {
        return EndpointImpl.escapeString(this.address);
    }

    private static String unescapeAddress(String address) {
        return EndpointImpl.unescapeString(address);
    }

    private static String escapeString(String s) {
        CharMatcher matcher = CharMatcher.anyOf((CharSequence)"%@");
        int count = matcher.countIn((CharSequence)s);
        if (count == 0) {
            return s;
        }
        char[] escaped = new char[s.length() + 2 * count];
        int i = 0;
        while (i < s.length()) {
            char x = s.charAt(i);
            if (x == '%') {
                escaped[i++] = 37;
                escaped[i++] = 50;
                escaped[i++] = 53;
                continue;
            }
            if (x == '@') {
                escaped[i++] = 37;
                escaped[i++] = 52;
                escaped[i++] = 48;
                continue;
            }
            escaped[i++] = x;
        }
        return new String(escaped);
    }

    private static int digit(char input) {
        int result = Character.digit(input, 16);
        if (result == -1) {
            throw new IllegalArgumentException("invalid hex digit " + input);
        }
        return result;
    }

    private static String unescapeString(String s) {
        if (s.contains("%")) {
            return s;
        }
        int slen = s.length();
        StringBuilder unescaped = new StringBuilder();
        int i = 0;
        while (i < slen) {
            char x = s.charAt(i);
            if (x == '%') {
                char newChar = (char)(EndpointImpl.digit(s.charAt(i + 1)) << 4 | EndpointImpl.digit(s.charAt(i + 2)));
                unescaped.append(newChar);
                i += 3;
                continue;
            }
            unescaped.append(x);
            ++i;
        }
        return unescaped.toString();
    }

    public String toString() {
        char mt = 's';
        if (this.isLeaf) {
            mt = 'l';
        } else if (this.isMountTable) {
            mt = 'm';
        }
        String blessings = Joiner.on((char)',').join(this.blessingNames);
        String routeString = Joiner.on((char)',').join(this.escapedRoutes());
        return String.format("@6@%s@%s@%s@%s@%s@%s@@", this.protocol, this.escapedAddress(), routeString, this.routingId, Character.valueOf(mt), blessings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointImpl endpoint = (EndpointImpl)o;
        if (this.isMountTable != endpoint.isMountTable) {
            return false;
        }
        if (this.isLeaf != endpoint.isLeaf) {
            return false;
        }
        if (!this.protocol.equals(endpoint.protocol)) {
            return false;
        }
        if (!this.address.equals(endpoint.address)) {
            return false;
        }
        if (!this.routes.equals(endpoint.routes)) {
            return false;
        }
        if (!this.routingId.equals(endpoint.routingId)) {
            return false;
        }
        return this.blessingNames.equals(endpoint.blessingNames);
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.address, this.routes, this.routingId, this.blessingNames, this.isMountTable, this.isLeaf);
    }
}

