/*
 * Decompiled with CFR 0.152.
 */
package io.v.impl.google.namespace;

import com.google.common.util.concurrent.ListenableFuture;
import io.v.impl.google.ListenableFutureCallback;
import io.v.v23.InputChannel;
import io.v.v23.Options;
import io.v.v23.context.VContext;
import io.v.v23.namespace.Namespace;
import io.v.v23.naming.GlobReply;
import io.v.v23.naming.MountEntry;
import io.v.v23.rpc.Callback;
import io.v.v23.security.access.Permissions;
import io.v.v23.verror.VException;
import java.util.List;
import java.util.Map;
import org.joda.time.Duration;

public class NamespaceImpl
implements Namespace {
    private final long nativeRef;

    private static native InputChannel<GlobReply> nativeGlob(long var0, VContext var2, String var3, Options var4) throws VException;

    private static native void nativeMount(long var0, VContext var2, String var3, String var4, Duration var5, Options var6, Callback<Void> var7);

    private static native void nativeUnmount(long var0, VContext var2, String var3, String var4, Options var5, Callback<Void> var6);

    private static native void nativeDelete(long var0, VContext var2, String var3, boolean var4, Options var5, Callback<Void> var6);

    private static native void nativeResolveToMountTable(long var0, VContext var2, String var3, Options var4, Callback<MountEntry> var5);

    private static native void nativeResolve(long var0, VContext var2, String var3, Options var4, Callback<MountEntry> var5);

    private static native boolean nativeFlushCacheEntry(long var0, VContext var2, String var3);

    private static native void nativeSetRoots(long var0, List<String> var2) throws VException;

    private static native void nativeSetPermissions(long var0, VContext var2, String var3, Permissions var4, String var5, Options var6, Callback<Void> var7);

    private static native void nativeGetPermissions(long var0, VContext var2, String var3, Options var4, Callback<Map<String, Permissions>> var5);

    private native void nativeFinalize(long var1);

    private NamespaceImpl(long nativeRef) {
        this.nativeRef = nativeRef;
    }

    @Override
    public ListenableFuture<Void> mount(VContext ctx, String name, String server, Duration ttl) {
        return this.mount(ctx, name, server, ttl, null);
    }

    @Override
    public ListenableFuture<Void> mount(VContext ctx, String name, String server, Duration ttl, Options options) {
        ListenableFutureCallback<Void> callback = new ListenableFutureCallback<Void>();
        NamespaceImpl.nativeMount(this.nativeRef, ctx, name, server, ttl, options, callback);
        return callback.getFuture(ctx);
    }

    @Override
    public ListenableFuture<Void> unmount(VContext ctx, String name, String server) {
        return this.unmount(ctx, name, server, null);
    }

    @Override
    public ListenableFuture<Void> unmount(VContext ctx, String name, String server, Options options) {
        ListenableFutureCallback<Void> callback = new ListenableFutureCallback<Void>();
        NamespaceImpl.nativeUnmount(this.nativeRef, ctx, name, server, options, callback);
        return callback.getFuture(ctx);
    }

    @Override
    public ListenableFuture<Void> delete(VContext ctx, String name, boolean deleteSubtree) {
        return this.delete(ctx, name, deleteSubtree, null);
    }

    @Override
    public ListenableFuture<Void> delete(VContext ctx, String name, boolean deleteSubtree, Options options) {
        ListenableFutureCallback<Void> callback = new ListenableFutureCallback<Void>();
        NamespaceImpl.nativeDelete(this.nativeRef, ctx, name, deleteSubtree, options, callback);
        return callback.getFuture(ctx);
    }

    @Override
    public ListenableFuture<MountEntry> resolve(VContext ctx, String name) {
        return this.resolve(ctx, name, null);
    }

    @Override
    public ListenableFuture<MountEntry> resolve(VContext ctx, String name, Options options) {
        ListenableFutureCallback<MountEntry> callback = new ListenableFutureCallback<MountEntry>();
        NamespaceImpl.nativeResolve(this.nativeRef, ctx, name, options, callback);
        return callback.getFuture(ctx);
    }

    @Override
    public ListenableFuture<MountEntry> resolveToMountTable(VContext ctx, String name) {
        return this.resolveToMountTable(ctx, name, null);
    }

    @Override
    public ListenableFuture<MountEntry> resolveToMountTable(VContext ctx, String name, Options options) {
        ListenableFutureCallback<MountEntry> callback = new ListenableFutureCallback<MountEntry>();
        NamespaceImpl.nativeResolveToMountTable(this.nativeRef, ctx, name, options, callback);
        return callback.getFuture(ctx);
    }

    @Override
    public boolean flushCacheEntry(VContext ctx, String name) {
        return NamespaceImpl.nativeFlushCacheEntry(this.nativeRef, ctx, name);
    }

    @Override
    public InputChannel<GlobReply> glob(VContext ctx, String pattern) {
        return this.glob(ctx, pattern, null);
    }

    @Override
    public InputChannel<GlobReply> glob(VContext ctx, String pattern, Options options) {
        try {
            return NamespaceImpl.nativeGlob(this.nativeRef, ctx, pattern, options);
        }
        catch (VException e) {
            throw new RuntimeException("Couldn't create glob InputChannel.", e);
        }
    }

    @Override
    public void setRoots(List<String> roots) throws VException {
        NamespaceImpl.nativeSetRoots(this.nativeRef, roots);
    }

    @Override
    public ListenableFuture<Void> setPermissions(VContext ctx, String name, Permissions permissions, String version) {
        return this.setPermissions(ctx, name, permissions, version, null);
    }

    @Override
    public ListenableFuture<Void> setPermissions(VContext ctx, String name, Permissions permissions, String version, Options options) {
        ListenableFutureCallback<Void> callback = new ListenableFutureCallback<Void>();
        NamespaceImpl.nativeSetPermissions(this.nativeRef, ctx, name, permissions, version, options, callback);
        return callback.getFuture(ctx);
    }

    @Override
    public ListenableFuture<Map<String, Permissions>> getPermissions(VContext ctx, String name) {
        return this.getPermissions(ctx, name, null);
    }

    @Override
    public ListenableFuture<Map<String, Permissions>> getPermissions(VContext ctx, String name, Options options) {
        ListenableFutureCallback<Map<String, Permissions>> callback = new ListenableFutureCallback<Map<String, Permissions>>();
        NamespaceImpl.nativeGetPermissions(this.nativeRef, ctx, name, options, callback);
        return callback.getFuture(ctx);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.nativeRef == ((NamespaceImpl)other).nativeRef;
    }

    public int hashCode() {
        return Long.valueOf(this.nativeRef).hashCode();
    }

    protected void finalize() {
        this.nativeFinalize(this.nativeRef);
    }
}

