/*
 * Decompiled with CFR 0.152.
 */
package io.v.impl.google.lib.discovery;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.impl.google.ListenableFutureCallback;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.discovery.AdId;
import io.v.v23.discovery.Advertisement;
import io.v.v23.discovery.Attachments;
import io.v.v23.discovery.Attributes;
import io.v.v23.discovery.Update;
import io.v.v23.verror.VException;
import io.v.v23.vom.VomUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

class UpdateImpl
implements Update {
    private final long nativeRef;
    private boolean lost;
    private Advertisement ad;
    private long timestampNs;

    private native void nativeAttachment(long var1, VContext var3, String var4, ListenableFutureCallback<byte[]> var5) throws VException;

    private native void nativeFinalize(long var1);

    private UpdateImpl(long nativeRef, boolean lost, Advertisement ad, long timestampNs) {
        this.nativeRef = nativeRef;
        this.lost = lost;
        this.ad = ad;
        this.timestampNs = timestampNs;
    }

    @Override
    public boolean isLost() {
        return this.lost;
    }

    @Override
    public AdId getId() {
        return this.ad.getId();
    }

    @Override
    public String getInterfaceName() {
        return this.ad.getInterfaceName();
    }

    @Override
    public List<String> getAddresses() {
        return ImmutableList.copyOf(this.ad.getAddresses());
    }

    @Override
    public String getAttribute(String name) {
        Attributes attributes = this.ad.getAttributes();
        if (attributes != null) {
            return (String)attributes.get(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<byte[]> getAttachment(VContext ctx, final String name) throws VException {
        Advertisement advertisement = this.ad;
        synchronized (advertisement) {
            Attachments attachments = this.ad.getAttachments();
            if (attachments != null && attachments.containsKey(name)) {
                byte[] data = (byte[])attachments.get(name);
                return Futures.immediateFuture((Object)Arrays.copyOf(data, data.length));
            }
        }
        ListenableFutureCallback<byte[]> callback = new ListenableFutureCallback<byte[]>();
        this.nativeAttachment(this.nativeRef, ctx, name, callback);
        return VFutures.withUserLandChecks(ctx, Futures.transform(callback.getVanillaFuture(), (Function)new Function<byte[], byte[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public byte[] apply(byte[] data) {
                Advertisement advertisement = UpdateImpl.this.ad;
                synchronized (advertisement) {
                    Attachments attachments = UpdateImpl.this.ad.getAttachments();
                    if (attachments == null) {
                        attachments = new Attachments();
                        UpdateImpl.this.ad.setAttachments(attachments);
                    }
                    attachments.put(name, data);
                    return Arrays.copyOf(data, data.length);
                }
            }
        }));
    }

    @Override
    public Advertisement getAdvertisement() {
        return new Advertisement(this.ad.getId(), this.ad.getInterfaceName(), (List<String>)ImmutableList.copyOf(this.ad.getAddresses()), new Attributes((Map<String, String>)ImmutableMap.copyOf((Map)this.ad.getAttributes())), new Attachments(Maps.transformValues((Map)this.ad.getAttachments(), (Function)new Function<byte[], byte[]>(){

            public byte[] apply(byte[] data) {
                return Arrays.copyOf(data, data.length);
            }
        })));
    }

    @Override
    public long getTimestampNs() {
        return this.timestampNs;
    }

    public String toString() {
        return String.format("{%b %s %s %s %s}", this.lost, VomUtil.bytesToHexString(this.ad.getId().toPrimitiveArray()), this.ad.getInterfaceName(), this.ad.getAddresses(), this.ad.getAttributes());
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.nativeFinalize(this.nativeRef);
    }
}

