/*
 * Decompiled with CFR 0.152.
 */
package io.v.impl.google.lib.discovery;

import com.google.common.util.concurrent.FutureFallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.impl.google.ListenableFutureCallback;
import io.v.v23.InputChannel;
import io.v.v23.context.VContext;
import io.v.v23.discovery.Advertisement;
import io.v.v23.discovery.Discovery;
import io.v.v23.discovery.Update;
import io.v.v23.security.BlessingPattern;
import io.v.v23.verror.VException;
import java.util.List;
import java.util.concurrent.CancellationException;

class DiscoveryImpl
implements Discovery {
    private final long nativeRef;

    private native void nativeAdvertise(long var1, VContext var3, Advertisement var4, List<BlessingPattern> var5, ListenableFutureCallback<Void> var6) throws VException;

    private native InputChannel<Update> nativeScan(long var1, VContext var3, String var4) throws VException;

    private native void nativeFinalize(long var1);

    private DiscoveryImpl(long nativeRef) {
        this.nativeRef = nativeRef;
    }

    @Override
    public ListenableFuture<Void> advertise(VContext ctx, Advertisement ad, List<BlessingPattern> visibility) throws VException {
        ListenableFutureCallback<Void> cb = new ListenableFutureCallback<Void>();
        this.nativeAdvertise(this.nativeRef, ctx, ad, visibility, cb);
        return Futures.withFallback(cb.getFuture(ctx), (FutureFallback)new FutureFallback<Void>(){

            public ListenableFuture<Void> create(Throwable t) {
                if (t instanceof CancellationException) {
                    return Futures.immediateFuture(null);
                }
                return Futures.immediateFailedFuture((Throwable)t);
            }
        });
    }

    @Override
    public InputChannel<Update> scan(VContext ctx, String query) throws VException {
        return this.nativeScan(this.nativeRef, ctx, query);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.nativeFinalize(this.nativeRef);
    }
}

