/*
 * Decompiled with CFR 0.152.
 */
package io.v.impl.google.channel;

import com.google.common.util.concurrent.ListenableFuture;
import io.v.impl.google.ListenableFutureCallback;
import io.v.v23.OutputChannel;
import io.v.v23.context.VContext;
import io.v.v23.rpc.Callback;

class OutputChannelImpl<T>
implements OutputChannel<T> {
    private final VContext ctx;
    private final long nativeConvertRef;
    private final long nativeSendRef;
    private final long nativeCloseRef;

    private static native <T> void nativeSend(long var0, long var2, T var4, Callback<Void> var5);

    private static native void nativeClose(long var0, Callback<Void> var2);

    private static native void nativeFinalize(long var0, long var2, long var4);

    private OutputChannelImpl(VContext ctx, long convertRef, long sendRef, long closeRef) {
        this.ctx = ctx;
        this.nativeConvertRef = convertRef;
        this.nativeSendRef = sendRef;
        this.nativeCloseRef = closeRef;
    }

    @Override
    public ListenableFuture<Void> send(T item) {
        ListenableFutureCallback<Void> callback = new ListenableFutureCallback<Void>();
        OutputChannelImpl.nativeSend(this.nativeConvertRef, this.nativeSendRef, item, callback);
        return callback.getFuture(this.ctx);
    }

    @Override
    public ListenableFuture<Void> close() {
        ListenableFutureCallback<Void> callback = new ListenableFutureCallback<Void>();
        OutputChannelImpl.nativeClose(this.nativeCloseRef, callback);
        return callback.getFuture(this.ctx);
    }

    protected void finalize() throws Throwable {
        OutputChannelImpl.nativeFinalize(this.nativeConvertRef, this.nativeSendRef, this.nativeCloseRef);
    }
}

