// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.services.syncbase.watchable;

/**
 * SyncgroupOp represents a change in the set of prefixes that should be tracked
 * by sync, i.e. the union of prefix sets across all syncgroups. Note that an
 * individual syncgroup's prefixes cannot be changed; this record type is used
 * to track changes due to syncgroup create/join/leave/destroy.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/syncbase/watchable.SyncgroupOp")
public class SyncgroupOp extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "SgId", index = 0)
  private io.v.x.ref.services.syncbase.server.interfaces.GroupId sgId;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Prefixes", index = 1)
  private java.util.List<java.lang.String> prefixes;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Remove", index = 2)
  private boolean remove;

  /**
   * Vdl type for {@link SyncgroupOp}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(SyncgroupOp.class);

  /**
   * Creates a new zero-value instance of {@link SyncgroupOp}.
   */
  public SyncgroupOp() {
    super(VDL_TYPE);

    this.sgId = new io.v.x.ref.services.syncbase.server.interfaces.GroupId();

    this.prefixes = new java.util.ArrayList<java.lang.String>();

    this.remove = false;
  }

  /**
   * Creates a new instance of {@link SyncgroupOp} with the provided field values.
   */
  public SyncgroupOp(
      io.v.x.ref.services.syncbase.server.interfaces.GroupId sgId,
      java.util.List<java.lang.String> prefixes,
      boolean remove) {
    super(VDL_TYPE);

    this.sgId = sgId;

    this.prefixes = prefixes;

    this.remove = remove;
  }

  public io.v.x.ref.services.syncbase.server.interfaces.GroupId getSgId() {
    return this.sgId;
  }

  public void setSgId(io.v.x.ref.services.syncbase.server.interfaces.GroupId sgId) {
    this.sgId = sgId;
  }

  public java.util.List<java.lang.String> getPrefixes() {
    return this.prefixes;
  }

  public void setPrefixes(java.util.List<java.lang.String> prefixes) {
    this.prefixes = prefixes;
  }

  public boolean getRemove() {
    return this.remove;
  }

  public void setRemove(boolean remove) {
    this.remove = remove;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    SyncgroupOp other = (SyncgroupOp) obj;

    if (this.sgId == null) {
      if (other.sgId != null) {
        return false;
      }
    } else if (!this.sgId.equals(other.sgId)) {
      return false;
    }

    if (this.prefixes == null) {
      if (other.prefixes != null) {
        return false;
      }
    } else if (!this.prefixes.equals(other.prefixes)) {
      return false;
    }

    if (this.remove != other.remove) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.sgId == null ? 0 : this.sgId.hashCode());

    result = prime * result + (this.prefixes == null ? 0 : this.prefixes.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.remove).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "sgId:" + this.sgId;

    result += ", ";

    result += "prefixes:" + this.prefixes;

    result += ", ";

    result += "remove:" + this.remove;

    return result + "}";
  }
}
