// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.services.syncbase.watchable;

/**
 * SyncSnapshotOp represents a snapshot operation when creating and joining a
 * syncgroup. The sync watcher needs to get a snapshot of the Database at the
 * point of creating/joining a syncgroup. A SyncSnapshotOp entry is written to
 * the log for each Database key that falls within the syncgroup prefixes. This
 * allows sync to initialize its metadata at the correct versions of the objects
 * when they become syncable. These log entries should be filtered by the
 * client-facing Watch interface because the user data did not actually change.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/syncbase/watchable.SyncSnapshotOp")
public class SyncSnapshotOp extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Key", index = 0)
  private byte[] key;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Version", index = 1)
  private byte[] version;

  /**
   * Vdl type for {@link SyncSnapshotOp}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(SyncSnapshotOp.class);

  /**
   * Creates a new zero-value instance of {@link SyncSnapshotOp}.
   */
  public SyncSnapshotOp() {
    super(VDL_TYPE);

    this.key = new byte[] {};

    this.version = new byte[] {};
  }

  /**
   * Creates a new instance of {@link SyncSnapshotOp} with the provided field values.
   */
  public SyncSnapshotOp(byte[] key, byte[] version) {
    super(VDL_TYPE);

    this.key = key;

    this.version = version;
  }

  public byte[] getKey() {
    return this.key;
  }

  public void setKey(byte[] key) {
    this.key = key;
  }

  public byte[] getVersion() {
    return this.version;
  }

  public void setVersion(byte[] version) {
    this.version = version;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    SyncSnapshotOp other = (SyncSnapshotOp) obj;

    if (!java.util.Arrays.equals(this.key, other.key)) {
      return false;
    }

    if (!java.util.Arrays.equals(this.version, other.version)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + java.util.Arrays.hashCode(this.key);

    result = prime * result + java.util.Arrays.hashCode(this.version);

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "key:" + java.util.Arrays.toString(this.key);

    result += ", ";

    result += "version:" + java.util.Arrays.toString(this.version);

    return result + "}";
  }
}
