// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.services.syncbase.watchable;

/**
 * DbStateChangeRequestOp represents a database state change request.
 * Specifically there are two events that create this op:
 * PauseSync, indicating a client request to pause sync on this db.
 * ResumeSync, indicating a client request to resume sync on this db.
 * Client watcher will ignore this op.
 */
@io.v.v23.vdl.GeneratedFromVdl(
  name = "v.io/x/ref/services/syncbase/watchable.DbStateChangeRequestOp"
)
public class DbStateChangeRequestOp extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "RequestType", index = 0)
  private io.v.x.ref.services.syncbase.watchable.StateChange requestType;

  /**
   * Vdl type for {@link DbStateChangeRequestOp}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(DbStateChangeRequestOp.class);

  /**
   * Creates a new zero-value instance of {@link DbStateChangeRequestOp}.
   */
  public DbStateChangeRequestOp() {
    super(VDL_TYPE);

    this.requestType = io.v.x.ref.services.syncbase.watchable.StateChange.PauseSync;
  }

  /**
   * Creates a new instance of {@link DbStateChangeRequestOp} with the provided field values.
   */
  public DbStateChangeRequestOp(io.v.x.ref.services.syncbase.watchable.StateChange requestType) {
    super(VDL_TYPE);

    this.requestType = requestType;
  }

  public io.v.x.ref.services.syncbase.watchable.StateChange getRequestType() {
    return this.requestType;
  }

  public void setRequestType(io.v.x.ref.services.syncbase.watchable.StateChange requestType) {
    this.requestType = requestType;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    DbStateChangeRequestOp other = (DbStateChangeRequestOp) obj;

    if (this.requestType == null) {
      if (other.requestType != null) {
        return false;
      }
    } else if (!this.requestType.equals(other.requestType)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.requestType == null ? 0 : this.requestType.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "requestType:" + this.requestType;

    return result + "}";
  }
}
