// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.services.syncbase.vsync;

/**
 * SgLocalState holds the syncgroup local state, only relevant to this member
 * (i.e. the local Syncbase).  This is needed for crash recovery of the internal
 * state transitions of the syncgroup.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/syncbase/vsync.SgLocalState")
public class SgLocalState extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "NumLocalJoiners", index = 0)
  private io.v.v23.vdl.VdlUint32 numLocalJoiners;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Watched", index = 1)
  private boolean watched;

  @io.v.v23.vdl.GeneratedFromVdl(name = "RemotePublisher", index = 2)
  private java.lang.String remotePublisher;

  @io.v.v23.vdl.GeneratedFromVdl(name = "SyncPending", index = 3)
  private boolean syncPending;

  @io.v.v23.vdl.GeneratedFromVdl(name = "PendingGenVec", index = 4)
  private io.v.x.ref.services.syncbase.server.interfaces.GenVector pendingGenVec;

  /**
   * Vdl type for {@link SgLocalState}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(SgLocalState.class);

  /**
   * Creates a new zero-value instance of {@link SgLocalState}.
   */
  public SgLocalState() {
    super(VDL_TYPE);

    this.numLocalJoiners = new io.v.v23.vdl.VdlUint32();

    this.watched = false;

    this.remotePublisher = "";

    this.syncPending = false;

    this.pendingGenVec = new io.v.x.ref.services.syncbase.server.interfaces.GenVector();
  }

  /**
   * Creates a new instance of {@link SgLocalState} with the provided field values.
   */
  public SgLocalState(
      io.v.v23.vdl.VdlUint32 numLocalJoiners,
      boolean watched,
      java.lang.String remotePublisher,
      boolean syncPending,
      io.v.x.ref.services.syncbase.server.interfaces.GenVector pendingGenVec) {
    super(VDL_TYPE);

    this.numLocalJoiners = numLocalJoiners;

    this.watched = watched;

    this.remotePublisher = remotePublisher;

    this.syncPending = syncPending;

    this.pendingGenVec = pendingGenVec;
  }

  /**
   * The count of local joiners to the same syncgroup.
   */
  public io.v.v23.vdl.VdlUint32 getNumLocalJoiners() {
    return this.numLocalJoiners;
  }

  /**
   * The count of local joiners to the same syncgroup.
   */
  public void setNumLocalJoiners(io.v.v23.vdl.VdlUint32 numLocalJoiners) {
    this.numLocalJoiners = numLocalJoiners;
  }

  /**
   * The syncgroup is watched when the sync Watcher starts processing the
   * syncgroup data.  When a syncgroup is created or joined, an entry is
   * added to the Watcher queue (log) to inform it from which point to
   * start accepting store mutations, an asynchronous notification similar
   * to regular store mutations.  When the Watcher processes that queue
   * entry, it sets this bit to true.  When Syncbase restarts, the value
   * of this bit allows the new sync Watcher to recreate its in-memory
   * state by resuming to watch only the prefixes of syncgroups that were
   * previously being watched.
   */
  public boolean getWatched() {
    return this.watched;
  }

  /**
   * The syncgroup is watched when the sync Watcher starts processing the
   * syncgroup data.  When a syncgroup is created or joined, an entry is
   * added to the Watcher queue (log) to inform it from which point to
   * start accepting store mutations, an asynchronous notification similar
   * to regular store mutations.  When the Watcher processes that queue
   * entry, it sets this bit to true.  When Syncbase restarts, the value
   * of this bit allows the new sync Watcher to recreate its in-memory
   * state by resuming to watch only the prefixes of syncgroups that were
   * previously being watched.
   */
  public void setWatched(boolean watched) {
    this.watched = watched;
  }

  /**
   * The syncgroup was published here by this remote peer (if non-empty
   * string), typically the syncgroup creator.  In this case the syncgroup
   * cannot be GCed locally even if it has no local joiners.
   */
  public java.lang.String getRemotePublisher() {
    return this.remotePublisher;
  }

  /**
   * The syncgroup was published here by this remote peer (if non-empty
   * string), typically the syncgroup creator.  In this case the syncgroup
   * cannot be GCed locally even if it has no local joiners.
   */
  public void setRemotePublisher(java.lang.String remotePublisher) {
    this.remotePublisher = remotePublisher;
  }

  /**
   * The syncgroup is in pending state on a device that learns the current
   * state of the syncgroup from another device but has not yet received
   * through peer-to-peer sync the history of the changes (DAG and logs).
   * This happens in two cases:
   * 1- A joiner was accepted into a syncgroup by a syncgroup admin and
   *    only given the current syncgroup info synchronously and will
   *    receive the full history later via p2p sync.
   * 2- A remote server where the syncgroup is published was told by the
   *    syncgroup publisher the current syncgroup info synchronously and
   *    will receive the full history later via p2p sync.
   * The pending state is over when the device reaches or exceeds the
   * knowledge level indicated in the pending genvec.  While SyncPending
   * is true, no local syncgroup mutations are allowed (i.e. no join or
   * set-spec requests).
   */
  public boolean getSyncPending() {
    return this.syncPending;
  }

  /**
   * The syncgroup is in pending state on a device that learns the current
   * state of the syncgroup from another device but has not yet received
   * through peer-to-peer sync the history of the changes (DAG and logs).
   * This happens in two cases:
   * 1- A joiner was accepted into a syncgroup by a syncgroup admin and
   *    only given the current syncgroup info synchronously and will
   *    receive the full history later via p2p sync.
   * 2- A remote server where the syncgroup is published was told by the
   *    syncgroup publisher the current syncgroup info synchronously and
   *    will receive the full history later via p2p sync.
   * The pending state is over when the device reaches or exceeds the
   * knowledge level indicated in the pending genvec.  While SyncPending
   * is true, no local syncgroup mutations are allowed (i.e. no join or
   * set-spec requests).
   */
  public void setSyncPending(boolean syncPending) {
    this.syncPending = syncPending;
  }

  public io.v.x.ref.services.syncbase.server.interfaces.GenVector getPendingGenVec() {
    return this.pendingGenVec;
  }

  public void setPendingGenVec(
      io.v.x.ref.services.syncbase.server.interfaces.GenVector pendingGenVec) {
    this.pendingGenVec = pendingGenVec;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    SgLocalState other = (SgLocalState) obj;

    if (this.numLocalJoiners == null) {
      if (other.numLocalJoiners != null) {
        return false;
      }
    } else if (!this.numLocalJoiners.equals(other.numLocalJoiners)) {
      return false;
    }

    if (this.watched != other.watched) {
      return false;
    }

    if (this.remotePublisher == null) {
      if (other.remotePublisher != null) {
        return false;
      }
    } else if (!this.remotePublisher.equals(other.remotePublisher)) {
      return false;
    }

    if (this.syncPending != other.syncPending) {
      return false;
    }

    if (this.pendingGenVec == null) {
      if (other.pendingGenVec != null) {
        return false;
      }
    } else if (!this.pendingGenVec.equals(other.pendingGenVec)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.numLocalJoiners == null ? 0 : this.numLocalJoiners.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.watched).hashCode();

    result = prime * result + (this.remotePublisher == null ? 0 : this.remotePublisher.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.syncPending).hashCode();

    result = prime * result + (this.pendingGenVec == null ? 0 : this.pendingGenVec.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "numLocalJoiners:" + this.numLocalJoiners;

    result += ", ";

    result += "watched:" + this.watched;

    result += ", ";

    result += "remotePublisher:" + this.remotePublisher;

    result += ", ";

    result += "syncPending:" + this.syncPending;

    result += ", ";

    result += "pendingGenVec:" + this.pendingGenVec;

    return result + "}";
  }
}
