// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.services.syncbase.vsync;

/**
 * DbSyncState represents the persistent sync state of a Database.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/syncbase/vsync.DbSyncState")
public class DbSyncState extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "GenVecs", index = 0)
  private io.v.x.ref.services.syncbase.server.interfaces.Knowledge genVecs;

  @io.v.v23.vdl.GeneratedFromVdl(name = "SgGenVecs", index = 1)
  private io.v.x.ref.services.syncbase.server.interfaces.Knowledge sgGenVecs;

  @io.v.v23.vdl.GeneratedFromVdl(name = "IsPaused", index = 2)
  private boolean isPaused;

  /**
   * Vdl type for {@link DbSyncState}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(DbSyncState.class);

  /**
   * Creates a new zero-value instance of {@link DbSyncState}.
   */
  public DbSyncState() {
    super(VDL_TYPE);

    this.genVecs = new io.v.x.ref.services.syncbase.server.interfaces.Knowledge();

    this.sgGenVecs = new io.v.x.ref.services.syncbase.server.interfaces.Knowledge();

    this.isPaused = false;
  }

  /**
   * Creates a new instance of {@link DbSyncState} with the provided field values.
   */
  public DbSyncState(
      io.v.x.ref.services.syncbase.server.interfaces.Knowledge genVecs,
      io.v.x.ref.services.syncbase.server.interfaces.Knowledge sgGenVecs,
      boolean isPaused) {
    super(VDL_TYPE);

    this.genVecs = genVecs;

    this.sgGenVecs = sgGenVecs;

    this.isPaused = isPaused;
  }

  /**
   * knowledge capturing the locally-known generations of remote peers for data in Database.
   */
  public io.v.x.ref.services.syncbase.server.interfaces.Knowledge getGenVecs() {
    return this.genVecs;
  }

  /**
   * knowledge capturing the locally-known generations of remote peers for data in Database.
   */
  public void setGenVecs(io.v.x.ref.services.syncbase.server.interfaces.Knowledge genVecs) {
    this.genVecs = genVecs;
  }

  /**
   * knowledge capturing the locally-known generations of remote peers for syncgroups in Database.
   */
  public io.v.x.ref.services.syncbase.server.interfaces.Knowledge getSgGenVecs() {
    return this.sgGenVecs;
  }

  /**
   * knowledge capturing the locally-known generations of remote peers for syncgroups in Database.
   */
  public void setSgGenVecs(io.v.x.ref.services.syncbase.server.interfaces.Knowledge sgGenVecs) {
    this.sgGenVecs = sgGenVecs;
  }

  /**
   * tracks whether sync is paused by client.
   */
  public boolean getIsPaused() {
    return this.isPaused;
  }

  /**
   * tracks whether sync is paused by client.
   */
  public void setIsPaused(boolean isPaused) {
    this.isPaused = isPaused;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    DbSyncState other = (DbSyncState) obj;

    if (this.genVecs == null) {
      if (other.genVecs != null) {
        return false;
      }
    } else if (!this.genVecs.equals(other.genVecs)) {
      return false;
    }

    if (this.sgGenVecs == null) {
      if (other.sgGenVecs != null) {
        return false;
      }
    } else if (!this.sgGenVecs.equals(other.sgGenVecs)) {
      return false;
    }

    if (this.isPaused != other.isPaused) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.genVecs == null ? 0 : this.genVecs.hashCode());

    result = prime * result + (this.sgGenVecs == null ? 0 : this.sgGenVecs.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.isPaused).hashCode();

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "genVecs:" + this.genVecs;

    result += ", ";

    result += "sgGenVecs:" + this.sgGenVecs;

    result += ", ";

    result += "isPaused:" + this.isPaused;

    return result + "}";
  }
}
