// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.services.syncbase.vsync;

/**
 * DagNode holds the information on an object mutation in the DAG.  The node
 * information is extracted from the log records exchanged between Syncbases.
 * They are also stored in the DAG node to improve DAG traversal for conflict
 * resolution and pruning without having to fetch the full log record.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/syncbase/vsync.DagNode")
public class DagNode extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Level", index = 0)
  private io.v.v23.vdl.VdlUint64 level;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Parents", index = 1)
  private java.util.List<java.lang.String> parents;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Logrec", index = 2)
  private java.lang.String logrec;

  @io.v.v23.vdl.GeneratedFromVdl(name = "BatchId", index = 3)
  private io.v.v23.vdl.VdlUint64 batchId;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Deleted", index = 4)
  private boolean deleted;

  @io.v.v23.vdl.GeneratedFromVdl(name = "PermId", index = 5)
  private java.lang.String permId;

  @io.v.v23.vdl.GeneratedFromVdl(name = "PermVers", index = 6)
  private java.lang.String permVers;

  /**
   * Vdl type for {@link DagNode}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(DagNode.class);

  /**
   * Creates a new zero-value instance of {@link DagNode}.
   */
  public DagNode() {
    super(VDL_TYPE);

    this.level = new io.v.v23.vdl.VdlUint64();

    this.parents = new java.util.ArrayList<java.lang.String>();

    this.logrec = "";

    this.batchId = new io.v.v23.vdl.VdlUint64();

    this.deleted = false;

    this.permId = "";

    this.permVers = "";
  }

  /**
   * Creates a new instance of {@link DagNode} with the provided field values.
   */
  public DagNode(
      io.v.v23.vdl.VdlUint64 level,
      java.util.List<java.lang.String> parents,
      java.lang.String logrec,
      io.v.v23.vdl.VdlUint64 batchId,
      boolean deleted,
      java.lang.String permId,
      java.lang.String permVers) {
    super(VDL_TYPE);

    this.level = level;

    this.parents = parents;

    this.logrec = logrec;

    this.batchId = batchId;

    this.deleted = deleted;

    this.permId = permId;

    this.permVers = permVers;
  }

  /**
   * node distance from root
   */
  public io.v.v23.vdl.VdlUint64 getLevel() {
    return this.level;
  }

  /**
   * node distance from root
   */
  public void setLevel(io.v.v23.vdl.VdlUint64 level) {
    this.level = level;
  }

  /**
   * references to parent versions
   */
  public java.util.List<java.lang.String> getParents() {
    return this.parents;
  }

  /**
   * references to parent versions
   */
  public void setParents(java.util.List<java.lang.String> parents) {
    this.parents = parents;
  }

  /**
   * reference to log record
   */
  public java.lang.String getLogrec() {
    return this.logrec;
  }

  /**
   * reference to log record
   */
  public void setLogrec(java.lang.String logrec) {
    this.logrec = logrec;
  }

  /**
   * ID of a write batch
   */
  public io.v.v23.vdl.VdlUint64 getBatchId() {
    return this.batchId;
  }

  /**
   * ID of a write batch
   */
  public void setBatchId(io.v.v23.vdl.VdlUint64 batchId) {
    this.batchId = batchId;
  }

  /**
   * true if the change was a delete
   */
  public boolean getDeleted() {
    return this.deleted;
  }

  /**
   * true if the change was a delete
   */
  public void setDeleted(boolean deleted) {
    this.deleted = deleted;
  }

  /**
   * ID of the permissions controlling this version
   */
  public java.lang.String getPermId() {
    return this.permId;
  }

  /**
   * ID of the permissions controlling this version
   */
  public void setPermId(java.lang.String permId) {
    this.permId = permId;
  }

  /**
   * current version of the permissions object
   */
  public java.lang.String getPermVers() {
    return this.permVers;
  }

  /**
   * current version of the permissions object
   */
  public void setPermVers(java.lang.String permVers) {
    this.permVers = permVers;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    DagNode other = (DagNode) obj;

    if (this.level == null) {
      if (other.level != null) {
        return false;
      }
    } else if (!this.level.equals(other.level)) {
      return false;
    }

    if (this.parents == null) {
      if (other.parents != null) {
        return false;
      }
    } else if (!this.parents.equals(other.parents)) {
      return false;
    }

    if (this.logrec == null) {
      if (other.logrec != null) {
        return false;
      }
    } else if (!this.logrec.equals(other.logrec)) {
      return false;
    }

    if (this.batchId == null) {
      if (other.batchId != null) {
        return false;
      }
    } else if (!this.batchId.equals(other.batchId)) {
      return false;
    }

    if (this.deleted != other.deleted) {
      return false;
    }

    if (this.permId == null) {
      if (other.permId != null) {
        return false;
      }
    } else if (!this.permId.equals(other.permId)) {
      return false;
    }

    if (this.permVers == null) {
      if (other.permVers != null) {
        return false;
      }
    } else if (!this.permVers.equals(other.permVers)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.level == null ? 0 : this.level.hashCode());

    result = prime * result + (this.parents == null ? 0 : this.parents.hashCode());

    result = prime * result + (this.logrec == null ? 0 : this.logrec.hashCode());

    result = prime * result + (this.batchId == null ? 0 : this.batchId.hashCode());

    result = prime * result + java.lang.Boolean.valueOf(this.deleted).hashCode();

    result = prime * result + (this.permId == null ? 0 : this.permId.hashCode());

    result = prime * result + (this.permVers == null ? 0 : this.permVers.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "level:" + this.level;

    result += ", ";

    result += "parents:" + this.parents;

    result += ", ";

    result += "logrec:" + this.logrec;

    result += ", ";

    result += "batchId:" + this.batchId;

    result += ", ";

    result += "deleted:" + this.deleted;

    result += ", ";

    result += "permId:" + this.permId;

    result += ", ";

    result += "permVers:" + this.permVers;

    return result + "}";
  }
}
