// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.services.syncbase.vsync;

/**
 * BatchInfo holds the information on a write batch:
 *  * The map of syncable (versioned) objects: {oid: version}
 *  * The map of linked objects {oid: version} that were not explicitly written
 *    as part of the batch but were reaffirmed during conflict resolution along
 *    with other objects written in this batch by the app by choosing
 *    "pickLocal" or "pickRemote". NOTE: this map is non empty only for batches
 *    created during conflict resolution. Unlike the Objects map, the collection
 *    of oid:version present in this map do not point back to this batch. They
 *    point to the batches that there were originally created in.
 *  * The total count of batch objects, including non-syncable ones.
 * TODO(rdaoud): add support to track the read and scan sets.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/syncbase/vsync.BatchInfo")
public class BatchInfo extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Objects", index = 0)
  private java.util.Map<java.lang.String, java.lang.String> objects;

  @io.v.v23.vdl.GeneratedFromVdl(name = "LinkedObjects", index = 1)
  private java.util.Map<java.lang.String, java.lang.String> linkedObjects;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Count", index = 2)
  private io.v.v23.vdl.VdlUint64 count;

  /**
   * Vdl type for {@link BatchInfo}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(BatchInfo.class);

  /**
   * Creates a new zero-value instance of {@link BatchInfo}.
   */
  public BatchInfo() {
    super(VDL_TYPE);

    this.objects = new java.util.HashMap<java.lang.String, java.lang.String>();

    this.linkedObjects = new java.util.HashMap<java.lang.String, java.lang.String>();

    this.count = new io.v.v23.vdl.VdlUint64();
  }

  /**
   * Creates a new instance of {@link BatchInfo} with the provided field values.
   */
  public BatchInfo(
      java.util.Map<java.lang.String, java.lang.String> objects,
      java.util.Map<java.lang.String, java.lang.String> linkedObjects,
      io.v.v23.vdl.VdlUint64 count) {
    super(VDL_TYPE);

    this.objects = objects;

    this.linkedObjects = linkedObjects;

    this.count = count;
  }

  public java.util.Map<java.lang.String, java.lang.String> getObjects() {
    return this.objects;
  }

  public void setObjects(java.util.Map<java.lang.String, java.lang.String> objects) {
    this.objects = objects;
  }

  public java.util.Map<java.lang.String, java.lang.String> getLinkedObjects() {
    return this.linkedObjects;
  }

  public void setLinkedObjects(java.util.Map<java.lang.String, java.lang.String> linkedObjects) {
    this.linkedObjects = linkedObjects;
  }

  public io.v.v23.vdl.VdlUint64 getCount() {
    return this.count;
  }

  public void setCount(io.v.v23.vdl.VdlUint64 count) {
    this.count = count;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    BatchInfo other = (BatchInfo) obj;

    if (this.objects == null) {
      if (other.objects != null) {
        return false;
      }
    } else if (!this.objects.equals(other.objects)) {
      return false;
    }

    if (this.linkedObjects == null) {
      if (other.linkedObjects != null) {
        return false;
      }
    } else if (!this.linkedObjects.equals(other.linkedObjects)) {
      return false;
    }

    if (this.count == null) {
      if (other.count != null) {
        return false;
      }
    } else if (!this.count.equals(other.count)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + (this.objects == null ? 0 : this.objects.hashCode());

    result = prime * result + (this.linkedObjects == null ? 0 : this.linkedObjects.hashCode());

    result = prime * result + (this.count == null ? 0 : this.count.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "objects:" + this.objects;

    result += ", ";

    result += "linkedObjects:" + this.linkedObjects;

    result += ", ";

    result += "count:" + this.count;

    return result + "}";
  }
}
