// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.services.syncbase.vclock;

/**
 * VClockData is the persistent state of the Syncbase virtual clock.
 * All times are UTC.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/syncbase/vclock.VClockData")
public class VClockData extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "SystemTimeAtBoot", index = 0)
  private org.joda.time.DateTime systemTimeAtBoot;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Skew", index = 1)
  private org.joda.time.Duration skew;

  @io.v.v23.vdl.GeneratedFromVdl(name = "ElapsedTimeSinceBoot", index = 2)
  private org.joda.time.Duration elapsedTimeSinceBoot;

  @io.v.v23.vdl.GeneratedFromVdl(name = "LastNtpTs", index = 3)
  private org.joda.time.DateTime lastNtpTs;

  @io.v.v23.vdl.GeneratedFromVdl(name = "NumReboots", index = 4)
  private io.v.v23.vdl.VdlUint16 numReboots;

  @io.v.v23.vdl.GeneratedFromVdl(name = "NumHops", index = 5)
  private io.v.v23.vdl.VdlUint16 numHops;

  /**
   * Vdl type for {@link VClockData}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(VClockData.class);

  /**
   * Creates a new zero-value instance of {@link VClockData}.
   */
  public VClockData() {
    super(VDL_TYPE);

    this.systemTimeAtBoot = null;

    this.skew = null;

    this.elapsedTimeSinceBoot = null;

    this.lastNtpTs = null;

    this.numReboots = new io.v.v23.vdl.VdlUint16();

    this.numHops = new io.v.v23.vdl.VdlUint16();
  }

  /**
   * Creates a new instance of {@link VClockData} with the provided field values.
   */
  public VClockData(
      org.joda.time.DateTime systemTimeAtBoot,
      org.joda.time.Duration skew,
      org.joda.time.Duration elapsedTimeSinceBoot,
      org.joda.time.DateTime lastNtpTs,
      io.v.v23.vdl.VdlUint16 numReboots,
      io.v.v23.vdl.VdlUint16 numHops) {
    super(VDL_TYPE);

    this.systemTimeAtBoot = systemTimeAtBoot;

    this.skew = skew;

    this.elapsedTimeSinceBoot = elapsedTimeSinceBoot;

    this.lastNtpTs = lastNtpTs;

    this.numReboots = numReboots;

    this.numHops = numHops;
  }

  /**
   * System time at boot.
   */
  public org.joda.time.DateTime getSystemTimeAtBoot() {
    return this.systemTimeAtBoot;
  }

  /**
   * System time at boot.
   */
  public void setSystemTimeAtBoot(org.joda.time.DateTime systemTimeAtBoot) {
    this.systemTimeAtBoot = systemTimeAtBoot;
  }

  /**
   * Current estimate of NTP time minus system clock time.
   */
  public org.joda.time.Duration getSkew() {
    return this.skew;
  }

  /**
   * Current estimate of NTP time minus system clock time.
   */
  public void setSkew(org.joda.time.Duration skew) {
    this.skew = skew;
  }

  /**
   * Elapsed time since boot, as seen by VClockD. Used for detecting reboots.
   */
  public org.joda.time.Duration getElapsedTimeSinceBoot() {
    return this.elapsedTimeSinceBoot;
  }

  /**
   * Elapsed time since boot, as seen by VClockD. Used for detecting reboots.
   */
  public void setElapsedTimeSinceBoot(org.joda.time.Duration elapsedTimeSinceBoot) {
    this.elapsedTimeSinceBoot = elapsedTimeSinceBoot;
  }

  /**
   * NTP server timestamp from the most recent NTP sync, or zero value if none.
   * Note, the NTP sync may have been performed by some peer device.
   */
  public org.joda.time.DateTime getLastNtpTs() {
    return this.lastNtpTs;
  }

  /**
   * NTP server timestamp from the most recent NTP sync, or zero value if none.
   * Note, the NTP sync may have been performed by some peer device.
   */
  public void setLastNtpTs(org.joda.time.DateTime lastNtpTs) {
    this.lastNtpTs = lastNtpTs;
  }

  /**
   * Number of reboots since last NTP sync, accumulated across all hops of p2p
   * clock sync. E.g. if LastNtpTs came from some peer device, NumReboots will
   * equal that device's NumReboots at the time of sync plus the number of
   * reboots on this device since then.
   */
  public io.v.v23.vdl.VdlUint16 getNumReboots() {
    return this.numReboots;
  }

  /**
   * Number of reboots since last NTP sync, accumulated across all hops of p2p
   * clock sync. E.g. if LastNtpTs came from some peer device, NumReboots will
   * equal that device's NumReboots at the time of sync plus the number of
   * reboots on this device since then.
   */
  public void setNumReboots(io.v.v23.vdl.VdlUint16 numReboots) {
    this.numReboots = numReboots;
  }

  /**
   * Number of sync hops between this device and the source of LastNtpTs.
   */
  public io.v.v23.vdl.VdlUint16 getNumHops() {
    return this.numHops;
  }

  /**
   * Number of sync hops between this device and the source of LastNtpTs.
   */
  public void setNumHops(io.v.v23.vdl.VdlUint16 numHops) {
    this.numHops = numHops;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    VClockData other = (VClockData) obj;

    if (this.systemTimeAtBoot == null) {
      if (other.systemTimeAtBoot != null) {
        return false;
      }
    } else if (!this.systemTimeAtBoot.equals(other.systemTimeAtBoot)) {
      return false;
    }

    if (this.skew == null) {
      if (other.skew != null) {
        return false;
      }
    } else if (!this.skew.equals(other.skew)) {
      return false;
    }

    if (this.elapsedTimeSinceBoot == null) {
      if (other.elapsedTimeSinceBoot != null) {
        return false;
      }
    } else if (!this.elapsedTimeSinceBoot.equals(other.elapsedTimeSinceBoot)) {
      return false;
    }

    if (this.lastNtpTs == null) {
      if (other.lastNtpTs != null) {
        return false;
      }
    } else if (!this.lastNtpTs.equals(other.lastNtpTs)) {
      return false;
    }

    if (this.numReboots == null) {
      if (other.numReboots != null) {
        return false;
      }
    } else if (!this.numReboots.equals(other.numReboots)) {
      return false;
    }

    if (this.numHops == null) {
      if (other.numHops != null) {
        return false;
      }
    } else if (!this.numHops.equals(other.numHops)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result =
        prime * result + (this.systemTimeAtBoot == null ? 0 : this.systemTimeAtBoot.hashCode());

    result = prime * result + (this.skew == null ? 0 : this.skew.hashCode());

    result =
        prime * result
            + (this.elapsedTimeSinceBoot == null ? 0 : this.elapsedTimeSinceBoot.hashCode());

    result = prime * result + (this.lastNtpTs == null ? 0 : this.lastNtpTs.hashCode());

    result = prime * result + (this.numReboots == null ? 0 : this.numReboots.hashCode());

    result = prime * result + (this.numHops == null ? 0 : this.numHops.hashCode());

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "systemTimeAtBoot:" + this.systemTimeAtBoot;

    result += ", ";

    result += "skew:" + this.skew;

    result += ", ";

    result += "elapsedTimeSinceBoot:" + this.elapsedTimeSinceBoot;

    result += ", ";

    result += "lastNtpTs:" + this.lastNtpTs;

    result += ", ";

    result += "numReboots:" + this.numReboots;

    result += ", ";

    result += "numHops:" + this.numHops;

    return result + "}";
  }
}
