// Copyright 2015 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source: types.vdl
package io.v.x.ref.services.syncbase.store.watchable;

/**
 * PutOp represents a store put operation.  The new version is written instead
 * of the value to avoid duplicating the user data in the store.  The version
 * is used to access the user data of that specific mutation.
 */
@io.v.v23.vdl.GeneratedFromVdl(name = "v.io/x/ref/services/syncbase/store/watchable.PutOp")
public class PutOp extends io.v.v23.vdl.AbstractVdlStruct {
  private static final long serialVersionUID = 1L;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Key", index = 0)
  private byte[] key;

  @io.v.v23.vdl.GeneratedFromVdl(name = "Version", index = 1)
  private byte[] version;

  /**
   * Vdl type for {@link PutOp}.
   */
  public static final io.v.v23.vdl.VdlType VDL_TYPE =
      io.v.v23.vdl.Types.getVdlTypeFromReflect(PutOp.class);

  /**
   * Creates a new zero-value instance of {@link PutOp}.
   */
  public PutOp() {
    super(VDL_TYPE);

    this.key = new byte[] {};

    this.version = new byte[] {};
  }

  /**
   * Creates a new instance of {@link PutOp} with the provided field values.
   */
  public PutOp(byte[] key, byte[] version) {
    super(VDL_TYPE);

    this.key = key;

    this.version = version;
  }

  public byte[] getKey() {
    return this.key;
  }

  public void setKey(byte[] key) {
    this.key = key;
  }

  public byte[] getVersion() {
    return this.version;
  }

  public void setVersion(byte[] version) {
    this.version = version;
  }

  @Override
  public boolean equals(java.lang.Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (this.getClass() != obj.getClass()) return false;
    PutOp other = (PutOp) obj;

    if (!java.util.Arrays.equals(this.key, other.key)) {
      return false;
    }

    if (!java.util.Arrays.equals(this.version, other.version)) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int result = 1;
    int prime = 31;

    result = prime * result + java.util.Arrays.hashCode(this.key);

    result = prime * result + java.util.Arrays.hashCode(this.version);

    return result;
  }

  @Override
  public java.lang.String toString() {
    String result = "{";

    result += "key:" + java.util.Arrays.toString(this.key);

    result += ", ";

    result += "version:" + java.util.Arrays.toString(this.version);

    return result + "}";
  }
}
